/*
 * $Id: HTMLDocument.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日: 2005/07/24
 */
package feat2.template;


/**
 * HTML文書の最上位ノード。
 * @author SUGIMOTO Ken-ichi
 */
public interface HTMLDocument extends HTMLNode, CompositeNode {

    /**
     * このドキュメントのエンコーディングを返す。
     * @return
     */
    public String getEncoding();

    /**
     * このノードを先頭とするノードツリーからXPathにマッチするノードを返す。
     * @param xpath String
     * @throws NodeNotFoundException ノードが見つからなかったとき
     * @return
     */
    public HTMLNode find(String xpath) throws NodeNotFoundException;

    /**
     * このノードを先頭とするノードツリーからXPathにマッチするすべてのノードを返す。
     * @param xpath
     * @return XPathにマッチするノードが無かったら空のIteratorを返す。
     */
    public HTMLNodeList select(String xpath);


    public String toHTML();

}