/*
 * $Revision: 220 $ $Date: 2007-07-16 19:32:15 +0900 $
 * (C) 2004 SUGIMOTO Ken-ichi
 * 作成日： 2004/08/27
 */

package feat2.template;

import org.w3c.dom.Node;


/**
 * HTMLを構成するノードのインタフェース。
 */
public interface HTMLNode {

    public static final int
        NODETYPE_ELEMENT = Node.ELEMENT_NODE,
        NODETYPE_DOCUMENT = Node.DOCUMENT_NODE,
        NODETYPE_ATTRIBUTE = Node.ATTRIBUTE_NODE,
        NODETYPE_TEXT = Node.TEXT_NODE,
        NODETYPE_REMARK = Node.COMMENT_NODE;

    public HTMLNode getParent() throws NodeNotFoundException;

    public HTMLDocument getDocument() throws NodeNotFoundException;

    /**
     * 子ノードを返す。子ノードを持たない種類のノードの場合は
     * 常にNodeNotFoundExceptionがスローされる。
     * @return
     * @throws NodeNotFoundException
     */
    public HTMLNode getFirstChild() throws NodeNotFoundException;

    /**
     * 次のノードを返す。
     * @return
     */
    public HTMLNode getNext() throws NodeNotFoundException;

    /**
     * 前のノードを返す。
     * @return
     */
    public HTMLNode getPrev() throws NodeNotFoundException;

    /**
     * 最初の兄弟ノードを返す。
     * @return
     */
    public HTMLNode getFirst();

    /**
     * 最後の兄弟ノードを返す。
     * @return
     */
    public HTMLNode getLast();

    /**
     * このノードの値を返す。
     * ノードがText, Remark, Attributeの場合はそれぞれのテキスト値、
     * それ以外のノードはnullを返す。
     * @return ノードの値
     */
    public String getValue();

    /**
     * このノードの後ろにnodeを挿入する。
     * nodeがnullのときは何もしない。
     * @param node 新しく追加するノード。連鎖リストになっていても良い。
     */
    public void insertAfter(HTMLNode node);

    /**
     * このノードの前にnodeを挿入する。
     * nodeがnullのときは何もしない。
     * @param node 新しく追加するノード。連鎖リストになっていても良い。
     */
    public void insertBefore(HTMLNode node);

    /**
     * ノードをコピーする。
     * 複製されたノードは親を持たない。deepがtrueの場合、このノードを先頭とするサブツリー全体をコピーする。
     * falseのときはこのノードだけをコピーする。
     * このノードがElementノードのときはAttributeもコピーされる。
     * @param deep
     * @return
     */
    public HTMLNode copy(boolean deep);

    /**
     * このノード(を先頭とするサブツリー)をツリーから切り離す。
     */
    public void detach();

    /**
     * このノードの種類を返す。
     * 返される値はこのインタフェースの定義を参照。
     * @return
     */
    public int getNodeType();

    /**
     * このノードをHTMLに変換する。
     * HTMLはこのメソッドが呼び出される度に生成される。
     * 子ノードのHTMLもすべて出力する。
     * @return 入力と同じStringBuffer
     */
    public StringBuffer toHTML(StringBuffer buf);

}
