/*
 * $Id: CreditCardValidator.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 作成日: 2006/03/09
 */
package feat2.validation;

import java.util.Map;

import org.apache.commons.validator.GenericValidator;

/**
 * クレジットカード番号の検証。
 * @author SUGIMOTO Ken-ichi
 */
public class CreditCardValidator implements SingleValueValidator {

    public boolean validate(String value) {

        if ( ValidatorUtil.isBlankOrNull(value) )
            return true;

        return GenericValidator.isCreditCard(value);

    }

    public String getDefaultMessageId() {
        return "error.validation.creditcard";
    }

    public Map getKeyrowds() {
        return null;
    }

}
