/*
 * $Id: DateValidator.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 作成日: 2006/03/09
 */
package feat2.validation;

import java.util.Calendar;
import java.util.Map;

/**
 * 日付が正しいかどうか検証する。
 * 3つの入力値をそれぞれ年、月、日の数値として検証する。
 * @author SUGIMOTO Ken-ichi
 */
public class DateValidator implements ArrayValueValidator {

    public boolean validate(String[] value) {

        try {

            if ( ValidatorUtil.isBlankOrNull(value) )
                return true;

            if ( value.length != 3 )
                return false;

            if ( !ValidatorUtil.isNotBlank(value, 3) )
                return false;

            // 引数をint型に変換

            int[] elem = new int[3];
            for (int i = 0; i < 3; i++) {
                elem[i] = Integer.parseInt(value[i]);
            }

            // 日付が存在するか調べる

            Calendar cal = Calendar.getInstance();
            cal.setLenient(false);
            cal.set(elem[0], elem[1]-1, elem[2]);
            cal.get(Calendar.DAY_OF_MONTH);
        }

        catch (Exception ex) {
            return false;
        }

        return true;

    }

    public String getDefaultMessageId() {
        return "error.validation.date";
    }

    public Map getKeyrowds() {
        return null;
    }




}
