/*
 * $Id: PostalCodeValidator.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 作成日: 2006/03/09
 */
package feat2.validation;

import java.util.Map;

/**
 * 郵便番号の検証。区切りのハイフンはあってもなくても良い。
 * また、全角、半角を問わない。
 * @author SUGIMOTO Ken-ichi
 */
public class PostalCodeValidator implements SingleValueValidator {


    public boolean validate(String value) {

        if ( ValidatorUtil.isBlankOrNull(value) )
            return true;

        return value.matches("^[0-9０-９]{3}[\\-－]?[0-9０-９]{4}$");
    }

    public String getDefaultMessageId() {
        return "error.validation.postalcode";
    }

    public Map getKeyrowds() {
        return null;
    }



}
