/*
 * $Id: ClientException.java 223 2007-10-14 08:07:40Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日： 2005/3/2
 */
package feat2.xmlcommand;

import feat2.impl.XMLWriter;


/**
 * Flashクライアントに投げる例外。
 */
public class ClientException extends Exception {

    private static final long serialVersionUID = 1L;

    private String err;
    private String clientMessage;

    /**
     * @param message システム内部で表示するメッセージ
     * @param errorCode クライアントに返すエラーコード
     * @param clientMessage クライアントに表示するメッセージ
     */
    public ClientException(String message, String errorCode, String clientMessage) {
        super(message);
        err = errorCode;
        this.clientMessage = clientMessage;
    }

    /**
     * @param message システム内部で表示するメッセージ
     * @param errorCode クライアントに返すエラーコード
     */
    public ClientException(String message, String errorCode) {
        this(message, errorCode, null);
    }


    public String toXML() {
        XMLWriter w = new XMLWriter();
        if ( err != null ) {
            if ( clientMessage != null ) {
                w.setError(err, clientMessage);
            }
            else {
                w.setError(err);
            }
        }
        else {
            w.setError("error");
        }
        return w.toString();
    }

    /**
     * @return
     */
    public String getErrorCode() {
        return err;
    }

    /**
     * @return
     */
    public String getClientMessage() {
        return clientMessage;
    }

    public String toString() {
        return "ClientException - "+getMessage()+" "+err;
    }

}

