/*
 * Decompiled with CFR 0.152.
 */
package feat2;

import feat2.FeatErrors;
import feat2.FeatRuntimeException;
import feat2.FileUploadException;
import feat2.HTTPSessionException;
import feat2.HttpNotFoundException;
import feat2.ResourceManager;
import feat2.StringUtil;
import feat2.Util;
import feat2.config.CommandConfig;
import feat2.config.ConfigurationException;
import feat2.config.FeatConfig;
import feat2.config.FeatureConfig;
import feat2.config.type.Scope;
import feat2.impl.Cache;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class CommandContext
implements ResourceManager {
    private static Cache localCache = new Cache();
    private FeatConfig config;
    private FeatureConfig featureConfig;
    private CommandConfig commandConfig;
    private FeatErrors featureErrors;
    private HashMap attributes;
    private String featureName;
    private String commandName;
    private String outputName;
    private Throwable exception;
    private ServletContext servletContext;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private HashMap multipartItems;

    public CommandContext(FeatConfig config, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String featureName, String commandName) throws HttpNotFoundException {
        this.config = config;
        this.servletContext = servletContext;
        this.request = request;
        this.response = response;
        this.featureName = featureName;
        this.commandName = commandName;
        this.featureErrors = new FeatErrors(this);
        this.attributes = new HashMap();
        if (featureName == null) {
            throw new HttpNotFoundException("exception.CommandContext.featureName.notfound");
        }
        this.featureConfig = config.getFeatureConfig(featureName);
        if (this.featureConfig == null) {
            HttpNotFoundException ex = new HttpNotFoundException("exception.CommandContext.feature.notfound");
            ex.addKeyword("name", featureName);
            throw ex;
        }
        if (commandName == null) {
            throw new HttpNotFoundException("exception.CommandContext.commandName.notfound");
        }
        this.commandConfig = this.featureConfig.getCommandConfig(commandName);
        if (this.commandConfig == null) {
            HttpNotFoundException ex = new HttpNotFoundException("exception.CommandContext.command.notfound");
            ex.addKeyword("name", commandName);
            throw ex;
        }
        String encoding = this.getEncoding();
        if (encoding != null) {
            try {
                request.setCharacterEncoding(encoding);
            }
            catch (UnsupportedEncodingException ex) {
                throw new ConfigurationException(ex);
            }
        }
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public Map getMultipartRequestBody() throws FileUploadException {
        List items;
        if (this.multipartItems != null) {
            return this.multipartItems;
        }
        if (!this.isMultipartRequest()) {
            return null;
        }
        this.multipartItems = new HashMap();
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        try {
            items = upload.parseRequest(this.request);
        }
        catch (org.apache.commons.fileupload.FileUploadException ex) {
            throw new FileUploadException(ex);
        }
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            FileItem item = (FileItem)iter.next();
            MultipartFormItem formItem = new MultipartFormItem(item);
            this.multipartItems.put(formItem.getFieldName(), formItem);
        }
        return this.multipartItems;
    }

    public boolean isMultipartRequest() {
        return this.multipartItems != null || this.request.getMethod().equalsIgnoreCase("POST") && this.request.getContentType().indexOf("multipart/form-data") > -1;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    public Object getCacheObject(Object key) {
        return localCache.get(key);
    }

    public void putCacheObject(Object key, Object obj, long ttl) {
        localCache.put(key, obj, ttl);
    }

    public Object getAttribute(String name, Scope scope) {
        Object ret = null;
        switch (scope.getScope()) {
            case 0: {
                ret = this.getAttribute(name);
                break;
            }
            case 1: {
                ret = this.request.getAttribute(name);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                try {
                    ret = this.getSession().getAttribute(name);
                }
                catch (NullPointerException ex) {}
                break;
            }
            case 4: {
                ret = this.servletContext.getAttribute(name);
            }
        }
        return ret;
    }

    public void setAttribute(String name, Object value, Scope scope) throws HTTPSessionException {
        switch (scope.getScope()) {
            case 0: {
                this.setAttribute(name, value);
                break;
            }
            case 1: {
                this.request.setAttribute(name, value);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                HttpSession session = this.getSession();
                if (session == null) {
                    throw new HTTPSessionException("Bean\u3092\u30bb\u30c3\u30c8\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f\u304c\u30bb\u30c3\u30b7\u30e7\u30f3\u304c\u5f97\u3089\u308c\u307e\u305b\u3093\u3067\u3057\u305f " + this.getCurrentCommandConfig().getConfigPath());
                }
                session.setAttribute(name, value);
                break;
            }
            case 4: {
                this.servletContext.setAttribute(name, value);
            }
        }
    }

    public String getRequestParameter(String name) {
        String ret = this.request.getParameter(name);
        String encoding = this.getEncoding();
        if (ret != null && this.request.getMethod().equalsIgnoreCase("get") && this.config.isUseBodyEncodingForURI() && encoding != null) {
            try {
                ret = StringUtil.convertEncoding(ret, encoding);
                ret = StringUtil.correctJapaneseChars(ret, encoding);
            }
            catch (UnsupportedEncodingException ex) {
                throw new ConfigurationException(ex);
            }
        }
        return ret;
    }

    public String[] getRequestParameterValues(String name) {
        String[] ret = this.request.getParameterValues(name);
        String encoding = this.getEncoding();
        if (ret != null && this.request.getMethod().equalsIgnoreCase("get") && this.config.isUseBodyEncodingForURI() && encoding != null) {
            try {
                ret = StringUtil.convertEncoding(ret, encoding);
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = StringUtil.correctJapaneseChars(ret[i], encoding);
                }
            }
            catch (UnsupportedEncodingException ex) {
                throw new ConfigurationException(ex);
            }
        }
        return ret;
    }

    public Map getRequestParameterMap() {
        Map params = this.request.getParameterMap();
        HashMap<String, String[]> ret = new HashMap<String, String[]>(params.size());
        String encoding = this.getEncoding();
        if (this.request.getMethod().equalsIgnoreCase("get") && this.config.isUseBodyEncodingForURI() && encoding != null) {
            try {
                Iterator it = params.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    String[] value = (String[])params.get(key);
                    value = StringUtil.convertEncoding(value, encoding);
                    for (int i = 0; i < value.length; ++i) {
                        value[i] = StringUtil.correctJapaneseChars(value[i], encoding);
                    }
                    ret.put(key, value);
                }
            }
            catch (UnsupportedEncodingException ex) {
                throw new ConfigurationException(ex);
            }
        } else {
            ret.putAll(params);
        }
        return ret;
    }

    public FeatConfig getFeatConfig() {
        return this.config;
    }

    public HttpSession getSession() {
        Boolean createSession = this.getCurrentCommandConfig().getCreateSession();
        if (createSession == null) {
            createSession = this.getCurrentFeatureConfig().getCreateSession();
        }
        HttpSession session = this.request.getSession(createSession != null && createSession != false);
        return session;
    }

    public FeatureConfig getCurrentFeatureConfig() {
        return this.featureConfig;
    }

    public CommandConfig getCurrentCommandConfig() {
        return this.commandConfig;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public FeatErrors getFeatErrors() {
        return this.featureErrors;
    }

    public String getEncoding() {
        String ret = null;
        ret = this.getCurrentCommandConfig().getEncoding();
        if (ret == null) {
            ret = this.getCurrentFeatureConfig().getEncoding();
        }
        return ret;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public void setOutputName(String outputName) {
        this.outputName = outputName;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public String getStringResource(String name) {
        return this.getStringResource(this.getCurrentFeatureConfig(), name);
    }

    public String getStringResource(FeatureConfig featureConf, String name) {
        return this.getStringResource(featureConf, name, this.getLocale());
    }

    public String getStringResource(FeatureConfig featureConf, String name, Locale[] locale) {
        for (int i = 0; i < locale.length; ++i) {
            String ret = this.getStringResource(featureConf, name, locale[i]);
            if (ret == null) continue;
            return ret;
        }
        return this.getStringResource(featureConf, name, Util.NULL_LOCALE);
    }

    private String getStringResource(FeatureConfig featureConf, String resourceName, Locale locale) {
        int i;
        String ret = null;
        ArrayList<Locale> sequence = null;
        if (locale != Util.NULL_LOCALE) {
            sequence = Util.expandLocale(locale);
        } else {
            sequence = new ArrayList<Locale>();
            sequence.add(Util.NULL_LOCALE);
        }
        for (i = 0; i < sequence.size(); ++i) {
            ret = featureConf.getStringResource(resourceName, (Locale)sequence.get(i));
            if (ret == null) continue;
            return ret;
        }
        for (i = 0; i < sequence.size(); ++i) {
            ret = featureConf.getFeatConfig().getStringResource(resourceName, (Locale)sequence.get(i));
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public void setSessionLocale(Locale locale) {
        try {
            this.getSession().setAttribute("feat.feature_context.locale.KEY", (Object)locale);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public Locale[] getLocale() {
        LanguageRange[] languageRange;
        String acceptLanguage;
        Locale[] ret = null;
        try {
            Locale sessionLocale = (Locale)this.getSession().getAttribute("feat.feature_context.locale.KEY");
            if (sessionLocale != null) {
                ret = new Locale[]{sessionLocale};
            }
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        if (ret == null && this.request != null && ret == null && this.request != null && (acceptLanguage = this.request.getHeader("Accept-Language")) != null && acceptLanguage.length() > 0 && (languageRange = this.parseLanguageRange(acceptLanguage)).length > 0) {
            ret = new Locale[languageRange.length];
            for (int i = 0; i < languageRange.length; ++i) {
                ret[i] = languageRange[i].lang;
            }
        }
        if (ret == null) {
            ret = new Locale[]{Locale.getDefault()};
        }
        return ret;
    }

    private LanguageRange[] parseLanguageRange(String str) {
        String[] list = StringUtil.stripAll(StringUtil.split(str, ","));
        Object[] ret = new LanguageRange[list.length];
        for (int i = 0; i < list.length; ++i) {
            ret[i] = new LanguageRange(list[i], i);
        }
        Arrays.sort(ret);
        return ret;
    }

    private class LanguageRange
    implements Comparable {
        Locale lang;
        double quality;
        int index;

        LanguageRange(String str, int index) {
            this.index = index;
            if (str == null || str.length() == 0) {
                this.lang = null;
                this.quality = 0.0;
                return;
            }
            String[] part = StringUtil.stripAll(StringUtil.split(str, ";"));
            if (part.length != 0) {
                this.lang = this.parseLang(part[0]);
                if (part.length > 1) {
                    String[] token = StringUtil.stripAll(StringUtil.split(part[1], "="));
                    if (token.length > 1) {
                        this.quality = this.parseQuality(token[1]);
                    }
                } else {
                    this.quality = 1.0;
                }
            }
        }

        private Locale parseLang(String str) {
            Locale ret = null;
            if (str != null && str.length() > 0) {
                String[] l = StringUtil.split(str, "-");
                if (l.length == 1) {
                    ret = new Locale(l[0].toLowerCase());
                } else if (l.length >= 2) {
                    ret = new Locale(l[0].toLowerCase(), l[1].toUpperCase());
                }
            }
            return ret;
        }

        private double parseQuality(String token) {
            try {
                return Double.parseDouble(token);
            }
            catch (NumberFormatException ex) {
                return 0.0;
            }
        }

        public int compareTo(Object o) {
            return -this.compareTo_(o);
        }

        private int compareTo_(Object o) {
            LanguageRange oo = (LanguageRange)o;
            if (this.quality < oo.quality) {
                return -1;
            }
            if (this.quality > oo.quality) {
                return 1;
            }
            if (this.index < oo.index) {
                return -1;
            }
            if (this.index > oo.index) {
                return 1;
            }
            return 0;
        }
    }

    public class MultipartFormItem {
        private FileItem item;

        private MultipartFormItem(FileItem item) {
            this.item = item;
        }

        public String getContentType() {
            return this.item.getContentType();
        }

        public String getFieldName() {
            return this.item.getFieldName();
        }

        public String getFileName() {
            return this.item.getName();
        }

        public long getSize() {
            return this.item.getSize();
        }

        public String getString() {
            String encoding = CommandContext.this.getEncoding();
            if (encoding == null) {
                encoding = System.getProperty("file.encoding");
            }
            try {
                return this.item.getString(encoding);
            }
            catch (UnsupportedEncodingException ex) {
                throw new FeatRuntimeException(ex);
            }
        }

        public boolean isFormField() {
            return this.item.isFormField();
        }

        public boolean isInMemory() {
            return this.item.isInMemory();
        }

        public byte[] get() {
            return this.item.get();
        }

        public File getFile() throws IOException {
            File ret = File.createTempFile("feat_", null);
            try {
                this.item.write(ret);
            }
            catch (Exception ex) {
                throw new FeatRuntimeException(ex);
            }
            return ret;
        }
    }
}

