/*
 * Decompiled with CFR 0.152.
 */
package feat2;

import feat2.StringUtil;
import feat2.TemplateCacheEntry;
import feat2.TemplateParsingException;
import feat2.Util;
import feat2.config.BasicFileLocator;
import feat2.config.FileLocator;
import feat2.template.HTMLTemplate;
import feat2.template.HTMLTemplateParser;
import feat2.template.impl.HTMLParser15TemplateParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class TemplateLoader {
    private static HTMLTemplateParser parser = new HTMLParser15TemplateParser();
    private static Map templateCache = new HashMap();

    public static HTMLTemplate load(File file, String encoding) throws FileNotFoundException, TemplateParsingException, IOException {
        BasicFileLocator fl = new BasicFileLocator(file);
        return TemplateLoader.load((FileLocator)fl, Locale.getDefault(), encoding);
    }

    public static HTMLTemplate load(FileLocator file, Locale[] locale, String encoding) throws FileNotFoundException, TemplateParsingException, IOException {
        HTMLTemplate template = null;
        for (int i = 0; i < locale.length; ++i) {
            template = TemplateLoader.load(file, locale[i], encoding);
            if (template == null) continue;
            return template;
        }
        template = TemplateLoader.load(file, Util.NULL_LOCALE, encoding);
        if (template == null) {
            throw new FileNotFoundException(file.getURIString());
        }
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HTMLTemplate load(FileLocator file, Locale locale, String encoding) throws TemplateParsingException, IOException {
        ArrayList<Locale> seq = null;
        if (locale != Util.NULL_LOCALE) {
            seq = Util.expandLocale(locale);
        } else {
            seq = new ArrayList<Locale>();
            seq.add(Util.NULL_LOCALE);
        }
        HTMLTemplate ret = null;
        Map map = templateCache;
        synchronized (map) {
            for (int i = 0; i < seq.size(); ++i) {
                String filename = StringUtil.makeLocaleFilename(file.getFilename(), (Locale)seq.get(i));
                FileLocator f = file.newLocation(filename);
                String uristr = f.getURIString();
                TemplateCacheEntry entry = (TemplateCacheEntry)templateCache.get(uristr);
                if (entry != null) {
                    if (entry.isValid()) {
                        ret = entry.getTamplate();
                        break;
                    }
                    templateCache.put(uristr, null);
                }
                if (!f.exists()) continue;
                ret = parser.parseTemplate(f, encoding);
                entry = new TemplateCacheEntry(f, ret);
                templateCache.put(uristr, entry);
                break;
            }
        }
        return ret;
    }
}

