/*
 * Decompiled with CFR 0.152.
 */
package feat2.config;

import feat2.FeatError;
import feat2.FileResourceManager;
import feat2.ResourceManager;
import feat2.StringUtil;
import feat2.config.Config;
import java.util.HashMap;

public class ConfigError
implements FeatError {
    public static final String TYPE_NULL = "null";
    public static final String TYPE_CLASS_NOT_FOUND_EXCEPTION = "ClassNotFoundException";
    public static final String TYPE_INSTANTIATION_EXCEPTION = "InstantiationException";
    public static final String TYPE_ILLEGAL_ACCESS_EXCEPTION = "IllegalAccessException";
    public static final String TYPE_DATA_INTERFACE = "data_interface";
    public static final String TYPE_FILEDOWNLOAD_INTERFACE = "filedownload_interface";
    public static final String TYPE_EFFECTOR_INTERFACE = "effector_interface";
    public static final String TYPE_FETCHER_INTERFACE = "fetcher_interface";
    public static final String TYPE_VIEW_INTERFACE = "view_interface";
    public static final String TYPE_INTERCEPTOR_INTERFACE = "interceptor_interface";
    public static final String TYPE_REFERRENCE = "referrence";
    public static final String TYPE_REFERRENCE_VALIDATION = "referrence.validation";
    public static final String TYPE_REFERRENCE_RESPONSE = "referrence.response";
    public static final String TYPE_RESOURCE = "resource";
    public static final String TYPE_VALUE = "value";
    public static final String TYPE_VALUE_FORMAT = "value_format";
    public static final String TYPE_ERROR_RESPONSE = "error_response";
    public static final String TYPE_URI_SYNTAX = "error_uri_syntax";
    private String messageId;
    private String featureName;
    private Config componentConfig;
    private int level;
    private ResourceManager rm;
    private HashMap keywords;

    public ConfigError(String value, String messageId, int level, Config config) {
        this.level = level;
        try {
            this.featureName = config.getFeatureConfig().getName().getValue();
        }
        catch (NullPointerException ex) {
            this.featureName = "";
        }
        this.componentConfig = config;
        this.messageId = messageId;
        this.keywords = new HashMap();
        this.keywords.put(TYPE_VALUE, value);
        this.keywords.put("element", config.getConfigPath());
    }

    public ConfigError(String value, String attributeName, String errorType, int level, Config config) {
        this.level = level;
        try {
            this.featureName = config.getFeatureConfig().getName().getValue();
        }
        catch (NullPointerException ex) {
            this.featureName = "";
        }
        this.componentConfig = config;
        this.messageId = "error.config." + errorType;
        this.keywords = new HashMap();
        this.keywords.put(TYPE_VALUE, value);
        this.keywords.put("element", config.getConfigPath());
        this.keywords.put("attr", attributeName);
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public Config getComponentConfig() {
        return this.componentConfig;
    }

    public int getErrorLevel() {
        return this.level;
    }

    public void setResourceManager(ResourceManager rm) {
        this.rm = rm;
    }

    public void addKeyrowd(String key, String value) {
        this.keywords.put(key, value);
    }

    public String getMessage() throws IllegalStateException {
        String message;
        ResourceManager resourceManager = this.rm;
        if (resourceManager == null) {
            resourceManager = FileResourceManager.getInstance();
        }
        message = (message = resourceManager.getStringResource(this.messageId)) == null ? this.messageId : StringUtil.replaceParameters(message, this.keywords);
        return message;
    }
}

