/*
 * Decompiled with CFR 0.152.
 */
package feat2.impl;

import feat2.CommandContext;
import feat2.FeatRuntimeException;
import feat2.FileUploadException;
import feat2.Processor;
import feat2.PropertyAccessException;
import feat2.Response;
import feat2.StringUtil;
import feat2.config.RedirectConfig;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletOutputStream;

public class RedirectResponse
implements Response {
    private RedirectConfig config;

    public RedirectResponse(RedirectConfig config) {
        this.config = config;
    }

    public String output(CommandContext ctx) throws IOException, PropertyAccessException, FileUploadException {
        Map inputs = Processor.processInputs(this.config, ctx);
        if (this.config.getMethod().equalsIgnoreCase("get")) {
            RedirectResponse.redirectGet(this.config.getUri(), inputs, ctx);
        } else if (this.config.getMethod().equalsIgnoreCase("post")) {
            RedirectResponse.redirectPost(this.config.getUri(), inputs, ctx);
        } else {
            throw new FeatRuntimeException("");
        }
        return null;
    }

    public static void redirectGet(String uri, Map inputs, CommandContext ctx) throws UnsupportedEncodingException, IOException {
        String encoding = RedirectResponse.getEncoding(ctx);
        String query = null;
        StringBuffer queryBuf = new StringBuffer();
        if (uri.indexOf(35) > -1) {
            uri = uri.substring(0, uri.indexOf(35));
        }
        if (uri.indexOf(63) > -1) {
            query = uri.substring(uri.indexOf(63) + 1);
            uri = uri.substring(0, uri.indexOf(63));
            if (query != null) {
                queryBuf.append(query);
            }
        }
        ArrayList<String[]> queryList = new ArrayList<String[]>(inputs.size() * 2);
        Iterator keys = inputs.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String encKey = URLEncoder.encode(key, encoding);
            String[] value = RedirectResponse.toStringArray(inputs.get(key));
            for (int i = 0; i < value.length; ++i) {
                queryList.add(new String[]{encKey, URLEncoder.encode(value[i], encoding)});
            }
        }
        Iterator it = queryList.iterator();
        while (it.hasNext()) {
            String[] pair = (String[])it.next();
            if (queryBuf.length() > 0) {
                queryBuf.append('&');
            }
            queryBuf.append(pair[0]);
            queryBuf.append('=');
            if (pair[1] == null || pair[1].length() <= 0) continue;
            queryBuf.append(pair[1]);
        }
        String newUri = uri;
        if (queryBuf.length() > 0) {
            newUri = newUri + "?" + queryBuf.toString();
        }
        ctx.getResponse().sendRedirect(newUri);
    }

    public static void redirectPost(String uri, Map inputs, CommandContext ctx) throws IOException, UnsupportedEncodingException {
        String encoding = RedirectResponse.getEncoding(ctx);
        StringBuffer html = new StringBuffer();
        StringBuffer form = new StringBuffer();
        html.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" ");
        html.append("\"http://www.w3.org/TR/html4/strict.dtd\">\n");
        html.append("<html><head>");
        html.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=");
        html.append(encoding);
        html.append("\">\n");
        html.append("<script type=\"text/javascript\">\n<!--\n");
        html.append("function submitForm() {\n");
        html.append("    document.forms[0].submit();\n");
        html.append("}\n//-->\n</script></head>\n");
        form.append("<form name=\"form0\" method=\"post\" action=\"");
        form.append(uri);
        form.append("\">\n");
        Iterator it = inputs.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String[] val = RedirectResponse.toStringArray(inputs.get(key));
            if (val.length == 1) {
                form.append("<textarea name=\"").append(StringUtil.escapeHTMLText(key)).append("\">");
                form.append(StringUtil.escapeHTMLText(val[0]));
                form.append("</textarea>\n");
                continue;
            }
            if (val.length <= 1) continue;
            for (int i = 0; i < val.length; ++i) {
                form.append("<input type=\"checkbox\" name=\"");
                form.append(StringUtil.escapeHTMLText(key));
                form.append("\" value=\"");
                form.append(StringUtil.escapeHTMLText(val[i]));
                form.append("\" checked>\n");
            }
        }
        form.append("</form>\n");
        html.append("<body onLoad=\"submitForm();\"><div style=\"display: none\">");
        html.append(form);
        html.append("</div></body></html>");
        ctx.getResponse().setContentType("text/html; charset=" + encoding);
        ServletOutputStream out = ctx.getResponse().getOutputStream();
        out.write(html.toString().getBytes(encoding));
        out.flush();
        out.close();
    }

    private static String getEncoding(CommandContext ctx) {
        String encoding = ctx.getCurrentFeatureConfig().getEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    private static String[] toStringArray(Object o) {
        String[] ret;
        if (o == null) {
            return new String[0];
        }
        if (o instanceof String[]) {
            return (String[])o;
        }
        if (o.getClass().isArray()) {
            Object[] array = (Object[])o;
            ret = new String[array.length];
            for (int i = 0; i < array.length; ++i) {
                ret[i] = array[i].toString();
            }
        } else {
            ret = new String[]{o.toString()};
        }
        return ret;
    }
}

