/*
 * Decompiled with CFR 0.152.
 */
package feat2.template;

import feat2.template.HTMLElement;
import feat2.template.HTMLNode;
import feat2.template.HTMLNodeList;
import feat2.template.HTMLNodeMap;
import feat2.template.HTMLText;
import feat2.template.NodeIterator;
import feat2.template.NodeTreeIterator;
import feat2.template.impl.HTMLNodeListImpl;
import feat2.template.impl.HTMLNodeMapImpl;

public class NodeSelector {
    public static HTMLElement getElement(NodeIterator iterator) {
        iterator.mark();
        while (iterator.hasNext()) {
            HTMLNode node = iterator.nextNode();
            if (!(node instanceof HTMLElement)) continue;
            return (HTMLElement)node;
        }
        iterator.reset();
        return null;
    }

    public static HTMLElement getElement(NodeIterator iterator, int n) {
        iterator.mark();
        int counter = 0;
        while (iterator.hasNext()) {
            HTMLNode node = iterator.nextNode();
            if (!(node instanceof HTMLElement) || ++counter != n) continue;
            return (HTMLElement)node;
        }
        iterator.reset();
        return null;
    }

    public static HTMLText getText(NodeIterator iterator) {
        iterator.mark();
        while (iterator.hasNext()) {
            HTMLNode node = iterator.nextNode();
            if (!(node instanceof HTMLText)) continue;
            return (HTMLText)node;
        }
        iterator.reset();
        return null;
    }

    public static HTMLText getText(NodeIterator iterator, int n) {
        iterator.mark();
        int counter = 0;
        while (iterator.hasNext()) {
            HTMLNode node = iterator.nextNode();
            if (!(node instanceof HTMLText) || ++counter != n) continue;
            return (HTMLText)node;
        }
        iterator.reset();
        return null;
    }

    public static HTMLText getLastText(NodeIterator iterator) {
        iterator.mark();
        HTMLText ret = null;
        while (iterator.hasNext()) {
            HTMLNode node = iterator.nextNode();
            if (!(node instanceof HTMLText)) continue;
            ret = (HTMLText)node;
        }
        if (ret == null) {
            iterator.reset();
        }
        return ret;
    }

    public static HTMLNodeList selectTextNode(NodeIterator iterator) {
        HTMLNodeListImpl list = new HTMLNodeListImpl();
        while (iterator.hasNext()) {
            HTMLNode node = iterator.nextNode();
            if (!(node instanceof HTMLText)) continue;
            list.add(node);
        }
        return list;
    }

    public static String joinText(HTMLNode node) {
        int spaceCount = 0;
        HTMLNodeList list = NodeSelector.selectTextNode(new NodeTreeIterator(node));
        int size = list.size();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            spaceCount = NodeSelector.joinText(buf, (HTMLText)list.get(i), spaceCount, i == 0);
        }
        return buf.toString();
    }

    private static int joinText(StringBuffer buf, HTMLText textNode, int spaceCount, boolean first) {
        String text = textNode.getText();
        if (text != null) {
            char[] c = text.toCharArray();
            int mode = 0;
            int i = 0;
            while (i < c.length) {
                switch (mode) {
                    case 0: {
                        if (c[i] == '\n' || c[i] == '\r' || c[i] == '\t' || c[i] == ' ') {
                            mode = 1;
                            break;
                        }
                        if (c[i] == '&') {
                            mode = 2;
                            break;
                        }
                        if (spaceCount > 0 && !first) {
                            buf.append(' ');
                        }
                        spaceCount = 0;
                        first = false;
                        buf.append(c[i]);
                        ++i;
                        break;
                    }
                    case 1: {
                        if (c[i] == '\n' || c[i] == '\r' || c[i] == '\t' || c[i] == ' ') {
                            ++spaceCount;
                            ++i;
                            break;
                        }
                        mode = 0;
                        break;
                    }
                    case 2: {
                        if (c.length - i >= 6) {
                            String nbsp = new String(c, i, 6);
                            if (nbsp.equals("&nbsp")) {
                                ++spaceCount;
                                i += 6;
                            } else {
                                buf.append(c[i]);
                                ++i;
                            }
                        } else {
                            buf.append(c[i]);
                            ++i;
                        }
                        mode = 0;
                    }
                }
            }
        }
        return spaceCount;
    }

    public static HTMLElement getTag(NodeIterator iterator, String tagName) {
        iterator.mark();
        while (iterator.hasNext()) {
            HTMLNode node = iterator.nextNode();
            if (!(node instanceof HTMLElement)) continue;
            HTMLElement element = (HTMLElement)node;
            String name = element.getTagName();
            if (!tagName.equals("*") && (name == null || !name.equalsIgnoreCase(tagName))) continue;
            return element;
        }
        iterator.reset();
        return null;
    }

    public static HTMLElement getTag(NodeIterator iterator, String tagName, int n) {
        iterator.mark();
        int counter = 0;
        while (iterator.hasNext()) {
            HTMLNode node = iterator.nextNode();
            if (!(node instanceof HTMLElement)) continue;
            HTMLElement element = (HTMLElement)node;
            if (!tagName.equals("*") && !element.getTagName().equalsIgnoreCase(tagName) || ++counter != n) continue;
            return element;
        }
        iterator.reset();
        return null;
    }

    public static HTMLElement getLastTag(NodeIterator iterator, String tagName) {
        iterator.mark();
        HTMLElement ret = null;
        while (iterator.hasNext()) {
            HTMLNode node = iterator.nextNode();
            if (!(node instanceof HTMLElement)) continue;
            HTMLElement element = (HTMLElement)node;
            String name = element.getTagName();
            if (!tagName.equals("*") && (name == null || !name.equalsIgnoreCase(tagName))) continue;
            ret = element;
        }
        if (ret == null) {
            iterator.reset();
        }
        return ret;
    }

    public static HTMLNodeList selectTags(NodeIterator iterator, String tagName) {
        HTMLNodeListImpl list = new HTMLNodeListImpl();
        while (iterator.hasNext()) {
            HTMLNode node = iterator.nextNode();
            if (!(node instanceof HTMLElement)) continue;
            HTMLElement element = (HTMLElement)node;
            String name = element.getTagName();
            if (!tagName.equals("*") && (name == null || !name.equalsIgnoreCase(tagName))) continue;
            list.add(node);
        }
        return list;
    }

    public static HTMLElement getElementByAttribute(NodeIterator iterator, String attrName, String attrVal) {
        iterator.mark();
        while (iterator.hasNext()) {
            HTMLElement element;
            String val;
            HTMLNode node = iterator.nextNode();
            if (!(node instanceof HTMLElement) || (val = (element = (HTMLElement)node).getAttribute(attrName)) == null || !val.equals(attrVal)) continue;
            return element;
        }
        iterator.reset();
        return null;
    }

    public static HTMLNodeList selectElementsByAttribute(NodeIterator iterator, String attrName, String attrVal) {
        HTMLNodeListImpl list = new HTMLNodeListImpl();
        while (iterator.hasNext()) {
            HTMLElement element;
            String val;
            HTMLNode node = iterator.nextNode();
            if (!(node instanceof HTMLElement) || (val = (element = (HTMLElement)node).getAttribute(attrName)) == null || !val.equals(attrVal)) continue;
            list.add(node);
        }
        return list;
    }

    public static HTMLElement getElementByClass(NodeIterator iterator, String className) {
        iterator.mark();
        while (iterator.hasNext()) {
            HTMLElement element;
            HTMLNode node = iterator.nextNode();
            if (!(node instanceof HTMLElement) || !(element = (HTMLElement)node).containsClassValue(className)) continue;
            return element;
        }
        iterator.reset();
        return null;
    }

    public static HTMLNodeList selectElementsByClass(NodeIterator iterator, String className) {
        HTMLNodeListImpl list = new HTMLNodeListImpl();
        while (iterator.hasNext()) {
            HTMLElement element;
            HTMLNode node = iterator.nextNode();
            if (!(node instanceof HTMLElement) || !(element = (HTMLElement)node).containsClassValue(className)) continue;
            list.add(node);
        }
        return list;
    }

    public static HTMLNodeMap selectIdentifiableElements(NodeIterator iterator) {
        HTMLNodeMapImpl map = new HTMLNodeMapImpl();
        while (iterator.hasNext()) {
            HTMLElement element;
            HTMLNode node = iterator.nextNode();
            if (!(node instanceof HTMLElement) || (element = (HTMLElement)node).getId() == null) continue;
            map.put(element.getId(), element);
        }
        return map;
    }
}

