/*
 * Decompiled with CFR 0.152.
 */
package feat2.template.impl;

import feat2.template.CompositeNode;
import feat2.template.HTMLElement;
import feat2.template.HTMLNode;
import feat2.template.HTMLNodeList;
import feat2.template.HTMLText;
import feat2.template.NodeListIterator;
import feat2.template.NodeNotFoundException;
import feat2.template.NodeSelector;
import feat2.template.NodeTreeIterator;
import feat2.template.impl.HTMLNodeImpl;
import feat2.template.impl.HTMLTextImpl;
import feat2.template.impl.TemplateUtil;

public abstract class HTMLCompositeNodeImpl
extends HTMLNodeImpl
implements CompositeNode {
    public HTMLNodeImpl firstChild;

    public void setFirstChild(HTMLNode child) {
        this.firstChild = (HTMLNodeImpl)child;
    }

    protected HTMLNode detachAll(HTMLNode node) {
        if (node == null) {
            return null;
        }
        try {
            ((HTMLNodeImpl)node.getPrev()).setNext(null);
        }
        catch (NodeNotFoundException ex) {
            // empty catch block
        }
        try {
            HTMLNodeImpl parentNode = (HTMLNodeImpl)node.getParent();
            if (parentNode.getFirstChild() == node) {
                parentNode.setFirstChild(null);
            }
        }
        catch (NodeNotFoundException nodeNotFoundException) {
            // empty catch block
        }
        TemplateUtil.setParentAll((HTMLNodeImpl)node, null, null);
        return node;
    }

    public HTMLNode getFirstChild() throws NodeNotFoundException {
        if (this.firstChild == null) {
            throw new NodeNotFoundException();
        }
        return this.firstChild;
    }

    public void addChild(HTMLNode node) {
        if (node == null) {
            return;
        }
        try {
            node.getParent();
            return;
        }
        catch (NodeNotFoundException ex) {
            HTMLNodeImpl child = (HTMLNodeImpl)node;
            if (this.firstChild == null) {
                this.firstChild = child;
                child.setPrev(null);
            } else {
                this.firstChild.getLast().insertAfter(child);
            }
            TemplateUtil.setParentAll(child, null, this);
            return;
        }
    }

    public String getString() {
        HTMLText textNode;
        StringBuffer buf = new StringBuffer();
        NodeListIterator it = new NodeListIterator(this.firstChild);
        while ((textNode = NodeSelector.getText(it)) != null) {
            buf.append(textNode.getText());
        }
        return buf.toString();
    }

    public void setText(String text) {
        this.clear();
        if (text != null) {
            this.addText(text);
        }
    }

    public void addText(String text) {
        if (text == null) {
            return;
        }
        HTMLText textNode = null;
        try {
            HTMLNode lastChild = this.getFirstChild().getLast();
            if (lastChild instanceof HTMLTextImpl) {
                ((HTMLTextImpl)lastChild).addText(text);
                return;
            }
        }
        catch (NodeNotFoundException nodeNotFoundException) {
            // empty catch block
        }
        if (textNode == null) {
            textNode = new HTMLTextImpl();
        }
        textNode.setText(text);
        this.addChild(textNode);
    }

    public void clear() {
        if (this.firstChild == null) {
            return;
        }
        TemplateUtil.setParentAll(this.firstChild, null, null);
        this.firstChild = null;
    }

    public HTMLElement getElement() throws NodeNotFoundException {
        HTMLElement ret = NodeSelector.getElement(new NodeListIterator(this.firstChild));
        if (ret == null) {
            throw new NodeNotFoundException();
        }
        return ret;
    }

    public HTMLElement getElement(int n) throws NodeNotFoundException {
        HTMLElement ret = NodeSelector.getElement(new NodeListIterator(this.firstChild), n);
        if (ret == null) {
            throw new NodeNotFoundException();
        }
        return ret;
    }

    public HTMLText getText() throws NodeNotFoundException {
        HTMLText ret = NodeSelector.getText(new NodeListIterator(this.firstChild));
        if (ret == null) {
            throw new NodeNotFoundException();
        }
        return ret;
    }

    public HTMLText getText(int n) throws NodeNotFoundException {
        HTMLText ret = NodeSelector.getText(new NodeListIterator(this.firstChild), n);
        if (ret == null) {
            throw new NodeNotFoundException();
        }
        return ret;
    }

    public HTMLText getLastText() throws NodeNotFoundException {
        HTMLText ret = NodeSelector.getLastText(new NodeListIterator(this.firstChild));
        if (ret == null) {
            throw new NodeNotFoundException();
        }
        return ret;
    }

    public HTMLElement getTag(String tagName) throws NodeNotFoundException {
        HTMLElement ret = NodeSelector.getTag(new NodeListIterator(this.firstChild), tagName);
        if (ret == null) {
            throw new NodeNotFoundException();
        }
        return ret;
    }

    public HTMLElement getTag(String tagName, int n) throws NodeNotFoundException {
        HTMLElement ret = NodeSelector.getTag(new NodeListIterator(this.firstChild), tagName, n);
        if (ret == null) {
            throw new NodeNotFoundException();
        }
        return ret;
    }

    public HTMLElement getLastTag(String tagName) throws NodeNotFoundException {
        HTMLElement ret = NodeSelector.getLastTag(new NodeListIterator(this.firstChild), tagName);
        if (ret == null) {
            throw new NodeNotFoundException();
        }
        return ret;
    }

    public int count() {
        int count = 0;
        NodeTreeIterator it = new NodeTreeIterator(this);
        while (it.hasNext()) {
            ++count;
            it.nextNode();
        }
        return count;
    }

    public HTMLElement findElement(String id) throws NodeNotFoundException {
        HTMLElement ret = this.findElementLocal(this, id);
        if (ret == null) {
            throw new NodeNotFoundException("HTMLCompositeNode.findElement(\"" + id + "\")");
        }
        return ret;
    }

    private HTMLElement findElementLocal(HTMLNodeImpl element, String id) {
        HTMLNodeImpl node = element;
        while (node != null) {
            HTMLElement ret;
            HTMLNodeImpl child;
            String xid;
            if (node instanceof HTMLElement && (xid = ((HTMLElement)((Object)node)).getId()) != null && xid.equals(id)) {
                return (HTMLElement)((Object)node);
            }
            if (node instanceof HTMLCompositeNodeImpl && (child = ((HTMLCompositeNodeImpl)node).firstChild) != null && (ret = this.findElementLocal(child, id)) != null) {
                return ret;
            }
            node = node.next;
        }
        return null;
    }

    public HTMLElement findElementByClass(String className) throws NodeNotFoundException {
        HTMLElement ret = NodeSelector.getElementByClass(new NodeTreeIterator(this), className);
        if (ret == null) {
            throw new NodeNotFoundException();
        }
        return ret;
    }

    public HTMLElement[] selectElementsByClass(String className) {
        HTMLNodeList list = NodeSelector.selectElementsByClass(new NodeTreeIterator(this), className);
        HTMLElement[] ret = new HTMLElement[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ret[i] = (HTMLElement)list.get(i);
        }
        return ret;
    }
}

