/*
 * Decompiled with CFR 0.152.
 */
package feat2.template.impl;

import feat2.FeatRuntimeException;
import feat2.template.CompositeNode;
import feat2.template.HTMLNode;
import feat2.template.HTMLNodeList;
import feat2.template.NodeListIterator;
import feat2.template.NodeNotFoundException;
import feat2.template.impl.HTMLCompositeNodeImpl;
import feat2.template.impl.HTMLNodeImpl;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TemplateUtil {
    public static HTMLNode copyNodeList(HTMLNodeImpl start, HTMLNode parent) {
        HTMLNodeImpl ret = null;
        HTMLNodeImpl prev = null;
        HTMLNodeImpl cur = start;
        while (cur != null) {
            HTMLNodeImpl cp = (HTMLNodeImpl)cur.copy(true);
            if (ret == null) {
                ret = cp;
            }
            if (prev != null) {
                prev.setNext(cp);
            }
            cp.setPrev(prev);
            cp.setParent(parent);
            prev = cp;
            cur = cur.next;
        }
        return ret;
    }

    public static StringBuffer nodeListToHTML(HTMLNode start, StringBuffer buf) {
        HTMLNode node = start;
        while (node != null) {
            node.toHTML(buf);
            node = ((HTMLNodeImpl)node).next;
        }
        return buf;
    }

    public static HTMLNode detachAll(HTMLNode node) {
        if (node == null) {
            return null;
        }
        try {
            HTMLNodeImpl prev = (HTMLNodeImpl)node.getPrev();
            prev.setNext(null);
        }
        catch (NodeNotFoundException ex) {
            // empty catch block
        }
        try {
            HTMLNodeImpl parent = (HTMLNodeImpl)node.getParent();
            if (parent.getFirstChild() == node) {
                parent.setFirstChild(null);
            }
        }
        catch (NodeNotFoundException nodeNotFoundException) {
            // empty catch block
        }
        TemplateUtil.setParentAll((HTMLNodeImpl)node, null, null);
        return node;
    }

    public static void moveAll(HTMLNode node, HTMLNode dest) {
        if (node == null || dest == null) {
            return;
        }
        TemplateUtil.detachAll(node);
        if (dest instanceof CompositeNode) {
            ((HTMLCompositeNodeImpl)dest).addChild(node);
        }
    }

    public static void setParentAll(HTMLNodeImpl start, HTMLNode end, HTMLNode newParent) {
        NodeListIterator it = new NodeListIterator(start);
        while (it.hasNext()) {
            HTMLNodeImpl n = (HTMLNodeImpl)it.next();
            n.setParent(newParent);
            if (n != end) continue;
            break;
        }
    }

    public static Node toDomNode(HTMLNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof HTMLNodeImpl) {
            return ((HTMLNodeImpl)node).getDomNode();
        }
        throw new FeatRuntimeException("HTMLNode\u304cDOM\u30a4\u30f3\u30bf\u30d5\u30a7\u30fc\u30b9\u3092\u6301\u3063\u3066\u3044\u306a\u3044");
    }

    public static NodeList toDomNodeList(HTMLNodeList list) {
        if (list instanceof NodeList) {
            return (NodeList)((Object)list);
        }
        return null;
    }
}

