/*
 * $Id: InputConfigBase.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日: 2006/02/20
 */
package feat2.config;

import feat2.FeatErrors;
import feat2.config.type.Identifier;
import feat2.config.type.JavaIdentifier;


/**
 * 入力設定の基本クラス。
 * @author SUGIMOTO Ken-ichi
 */
abstract public class InputConfigBase extends Config {

    private JavaIdentifier propertyName;
    /* この項目の表示名(リソース名)。リソースが無ければこの文字列をそのまま使用。 */
    private String displayName;

    public String getDisplayName() {
        return displayName;
    }
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public JavaIdentifier getPropertyName() {
        return propertyName;
    }
    public void setPropertyName(JavaIdentifier propertyName) {
        this.propertyName = propertyName;
    }

    public Identifier getName() {
        return new Identifier(propertyName.getValue());
    }

    public boolean validate(FeatErrors errs) {

        boolean ret = true;

        ret = ret && ConfigUtil.validateRequired(propertyName, "property", this, errs);

        return ret;
    }


}
