/*
 * $Id: CompositeNode.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日： 2005/07/28
 */
package feat2.template;




/**
 * 子ノードを持つことができるノード。
 * @author SUGIMOTO
 */
public interface CompositeNode {

    /**
     * 子ノードとしてchildを追加する。
     * @param node nullのときは何もしない。単体でも連鎖リストになっていても良い。
     */
    public void addChild(HTMLNode node);

    /**
     * 子ノードをすべて削除する。
     */
    public void clear();

    /**
     * このノードの直接の子ノードのうち、すべてのテキストノードの文字列を単純に連結して返す。
     * @return
     */
    public String getString();

    /**
     * 子ノードをすべて削除してテキストノードを追加する。
     * textはエスケープされる。
     * @param text String
     */
    public void setText(String text);

    /**
     * 子ノードのリストの最後に文字列を追加する。
     * リストの最後がテキストノードのときは、そのノードに文字列を追加する。
     * @param text String
     */
    public void addText(String text);

    /**
     * 子ノードのリストの中で最初に見つかった要素ノードを返す。
     * @return
     * @throws NodeNotFoundException ノードが見つからなかった
     */
    public HTMLElement getElement() throws NodeNotFoundException;

    /**
     * 子ノードのリストの中でn番目に見つかった要素ノードを返す。
     * @param n
     * @return
     * @throws NodeNotFoundException ノードが見つからなかった
     */
    public HTMLElement getElement(int n) throws NodeNotFoundException;

    /**
     * 子ノードのリストの中で最初に見つかったテキストノードを返す。
     * @return
     * @throws NodeNotFoundException ノードが見つからなかった
     */
    public HTMLText getText() throws NodeNotFoundException;

    /**
     * 子ノードのリストの中でn番目に見つかったテキストノードを返す。
     * @param n
     * @return
     * @throws NodeNotFoundException ノードが見つからなかった
     */
    public HTMLText getText(int n) throws NodeNotFoundException;

    /**
     * 子ノードのリストの中で最後に見つかったテキストノードを返す。
     * @return
     * @throws NodeNotFoundException ノードが見つからなかった
     */
    public HTMLText getLastText() throws NodeNotFoundException;

    /**
     * 子ノードのリストの中でタグ名がtagNameである最初に見つかった要素を返す。
     * @param tagName
     * @return
     * @throws NodeNotFoundException ノードが見つからなかった
     */
    public HTMLElement getTag(String tagName) throws NodeNotFoundException;

    /**
     * 子ノードのリストの中でタグ名がtagNameであるn番目に見つかった要素を返す。
     * @param tagName
     * @param n
     * @return
     * @throws NodeNotFoundException ノードが見つからなかった
     */
    public HTMLElement getTag(String tagName, int n) throws NodeNotFoundException;

    /**
     * 子ノードのリストの中でタグ名がtagNameである最後に見つかった要素を返す。
     * @param tagName
     * @return
     * @throws NodeNotFoundException ノードが見つからなかった
     */
    public HTMLElement getLastTag(String tagName) throws NodeNotFoundException;

    /**
     * 指定IDのタグをこのノード以下のサブツリーから探す。
     * @param id 検索するノードのID。大文字/小文字の区別がある。
     * @return
     * @throws NodeNotFoundException ノードが見つからなかった
     */
    public HTMLElement findElement(String id) throws NodeNotFoundException;

    /**
     * このノード以下のサブツリーで最初に見つかった指定クラスの要素返す。
     * @param className 検索するノードのクラス名
     * @return
     * @throws NodeNotFoundException ノードが見つからなかった
     */
    public HTMLElement findElementByClass(String className) throws NodeNotFoundException;

    /**
     * このノード以下のサブツリーで見つかった指定クラスの要素をすべて返す。
     * @param className 検索するノードのクラス名
     * @return 見つかったノード。一つも見つからなかったときは0を返す。
     */
    public HTMLElement[] selectElementsByClass(String className);

    /**
     * このノード以下のサブツリーのノード数を数える。
     * @return int
     */
    public int count();

}
