/*
 * $Id: Option.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日: 2005/12/08
 */
package feat2.template.form;

import feat2.template.HTMLElement;
import feat2.template.NodeFactory;

/**
 * リストの選択肢。
 * @author SUGIMOTO Ken-ichi
 */
public class Option implements ListItem {

    private HTMLElement element;

    public Option(String name, String value) {
        element = NodeFactory.createHTMLElement("option", true);
        element.setText(name);
        element.setAttribute("value", value);
    }

    public Option(HTMLElement element) {
        this.element = element;
    }

    public String getLabel() {
        return element.getAttribute("label");
    }

    /**
     * label属性を設定する。option要素の内容は変更しない。
     * option要素の内容はsetContentで設定する。
     * @param label
     */
    public void setLabel(String label) {
        if ( label == null )
            element.removeAttribute("label");
        else
            element.setAttribute("label", label);
    }

    /**
     * 値を返す。もし、value属性が設定されていなければ要素の内容を返す。
     * @return
     */
    public String getValue() {
        String value = element.getAttribute("value");
        if ( value == null )
            return getContent();
        else
            return value;

    }

    public void setValue(String value) {
        if ( value == null )
            element.removeAttribute("value");
        else
            element.setAttribute("value", value);
    }

    public boolean isSelected() {
        return element.hasAttribute("selected");
    }

    public void setSelected(boolean selected) {
        if ( selected )
            element.setAttribute("selected", null);
        else
            element.removeAttribute("selected");
    }

    public String getContent() {
        return element.getString();
    }

    public void setContent(String value) {
        element.setText(value);
    }

    public HTMLElement getElement() {
        return element;
    }


}
