/*
 * $Revision: 220 $ $Date: 2007-07-16 19:32:15 +0900 $
 * (C) 2005 SUGIMOTO Ken-ichi
 * 作成日： 2005/7/21
 */

package feat2.template.impl;

import feat2.StringUtil;
import feat2.template.HTMLNode;
import feat2.template.HTMLText;
import feat2.template.NodeNotFoundException;

/**
 * テキストノードを表すクラス。
 */
public class HTMLTextImpl extends HTMLNodeImpl implements HTMLText {

    private String text;

    /**
     * 空のテキストノードを作成する。
     */
    HTMLTextImpl() {
        this(null);
    }

    /**
     * 内容を指定してテキストノードを作成する。
     * @param rawText ノードの内容。エスケープされない。
     */
    public HTMLTextImpl(String rawText) {
        setRawText(rawText);
        setDomNode(new DOMTextImpl(this));
    }

    public void setText(String text) {
        if ( text != null )
            setRawText(StringUtil.escapeHTMLText(text));
        else
            setRawText(null);
    }

    public void setRawText(String str) {
        text = str;
    }

    public String getText() {
        if ( text == null )
            return null;
        else
            return StringUtil.unescapeHTMLText(text);
    }

    public void addText(String text) {
        addRawText(text == null ? null : StringUtil.escapeHTMLText(text));
    }

    public void addRawText(String str) {

        if ( str != null ) {
            if ( text == null )
                text = str;
            else
                text += str;
        }
    }

    public String toString() {
        if ( text != null )
            return StringUtil.unescapeHTMLText(text);
        else
            return "";
    }

    // HTMLNodeの実装 -----------------------------------------------------------

    public String getValue() {
        return getText();
    }

    public HTMLNode copy(boolean deep) {
        HTMLText ret = new HTMLTextImpl();
        ret.setRawText(text);
        return ret;
    }

    public StringBuffer toHTML(StringBuffer buf) {
        if ( text != null ) {
            String t;
            try {
                t = StringUtil.correctJapaneseChars(text, getDocument().getEncoding());
            }
            catch (NodeNotFoundException ex) {
                t = text;
            }
            buf.append(t);
        }
        return buf;
    }

    public int getNodeType() {
        return NODETYPE_TEXT;
    }

    public HTMLNode getFirstChild() throws NodeNotFoundException {
        throw new NodeNotFoundException();
    }

    public void setFirstChild(HTMLNode child) {
    }

}
