/*
 * $Id: IdentifierValidator.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 作成日: 2006/03/10
 */
package feat2.validation;

import java.util.Map;

import feat2.StringUtil;
import feat2.config.type.Identifier;

/**
 * feat識別子またはそのリスト(空白区切り)を検証する。
 * @author SUGIMOTO Ken-ichi
 */
public class IdentifierValidator implements SingleValueValidator {


    public boolean validate(String value) {

        if ( ValidatorUtil.isBlankOrNull(value) )
            return true;

        String[] list = StringUtil.split(value);

        for (int i = 0; i < list.length; i++) {
            if ( !Identifier.isIdentifier(list[i]) )
                return false;
        }

        return false;
    }

    public String getDefaultMessageId() {
        return "error.validation.identifier";
    }

    public Map getKeyrowds() {
        return null;
    }


}
