package feat2.test;
/*
 * $Revision: 220 $ $Date: 2007-07-16 19:32:15 +0900 $
 * Copyright (C) 2004-2005 SUGIMOTO Ken-ichi
 * 作成日： 2004/05/16
 */

import java.io.File;
import java.util.Locale;

import org.w3c.dom.Node;

import feat2.TemplateLoader;
import feat2.config.ClassLoaderFileLocator;
import feat2.template.HTMLDocument;
import feat2.template.HTMLElement;
import feat2.template.HTMLNode;
import feat2.template.HTMLNodeList;
import feat2.template.HTMLTemplate;
import feat2.template.NodeFactory;
import feat2.template.NodeNotFoundException;
import feat2.template.NodeSelector;
import feat2.template.NodeTreeIterator;

/**
 * ビューで出力するHTMLのテンプレート。
 */
public class TemplateTest {

    /*
     * 2005/9/7 Celeron2.0GHz DDR266 JRE1.4.2_05
     * ドキュメントのコピー:6.469ms
     * XPath ID検索:17.03ms
     * findElement(id):0.485ms
     * toHTML:3.984ms
     * ノード数:1759
     *
     * 2005/11/3 Celeron2.0GHz DDR266 JRE1.4.2_05
     * ドキュメントのコピー:31.516ms
     * XPath ID検索:64.06ms
     * findElement(id):13.094ms
     * toHTML:32.937ms
     * ノード数:1778
     *
     * getNextの例外をやめた場合
     * ドキュメントのコピー:10.578ms
     * XPath ID検索:22.81ms
     * findElement(id):8.0ms
     * toHTML:8.922ms
     * ノード数:1775
     *
     * ノードの移動をメソッドから変数の参照に変更
     * ドキュメントのコピー:6.859ms
     * HTMLDocument#find(XPath ID検索):14.69ms
     * CompositeNode#findElement(IDで検索):0.2266ms
     * NodeSelector.selectElementsByClass:0.4156ms
     * HTMLDocument#toHTML:3.641ms
     * ノード数:1775
     */

    public static void main(String[] args) {
        try {
            //HTMLTemplate t = TemplateLoader.load(new File("Z:\\files\\so-net.html"), null);
            HTMLTemplate t = TemplateLoader.load(new ClassLoaderFileLocator("testtemplate.html", ClassLoader.getSystemClassLoader()), new Locale[] {Locale.getDefault()}, null);
            HTMLDocument doc = t.getDocument();

            //
            // テキストの追加
            //

            try {
                HTMLElement htmlElem = doc.getTag("html");
                HTMLElement headElem = htmlElem.getTag("head");
                HTMLElement titleElem = headElem.getTag("title");
                titleElem.addText(" - タイトルに文字列追加</title>");
            }
            catch (NodeNotFoundException ex) {
                ex.printStackTrace();
            }

            /*HTMLElement html = NodeSelectUtil.getElementByTagName(doc.getFirstChild(), "html");
            HTMLElement head = NodeSelectUtil.getElementByTagName(doc.getFirstChild(), "head");
            HTMLElement title = NodeSelectUtil.getElementByTagName(head.getFirstChild(), "title");
            title.addText(" - タイトルに文字列追加</title>");*/

            //
            // タグの追加
            //

            try {
                HTMLNode firstChild = doc.findElement("test").getFirstChild();
                HTMLElement p = NodeFactory.createHTMLElement("p", true);
                p.setText("--- 追加したタグ ---");
                firstChild.insertBefore(p);
            }
            catch(NodeNotFoundException ex) {
                ex.printStackTrace();
            }

            try {
                HTMLElement metaElem = doc.getTag("html").getTag("head").getTag("meta", 2);
                metaElem.setAttribute("content", "--- パーサのテスト ---");
            }
            catch(NodeNotFoundException ex) {
                ex.printStackTrace();
            }

            //
            // XPath
            //

            try {
                HTMLElement xpath_head = (HTMLElement)doc.find("/html/head");

                // IDで検索
                HTMLElement xpath_test = (HTMLElement)doc.find("//*[@id=\"test\"]");

                // 複数ノード
                HTMLNodeList xpath_multiple = doc.select("//div");
                //HTMLNodeList xpath_multi_a = doc.select("//a");
                HTMLNodeList selectByClass = NodeSelector.selectElementsByClass(new NodeTreeIterator(doc), "cls_a");
                //Iterator it = doc.findTags(".//a");
                // アトリビュート
                HTMLNode xpath_attr = doc.find("html/@lang");
                HTMLNodeList selectByClass_XPath = doc.select("//*[@class=\"cls_a\"]");
                String langValue = ((HTMLElement)doc.find("/html")).getAttribute("lang");
            }
            catch (NodeNotFoundException ex) {
            }

            System.out.println(doc.toHTML());

            //
            // 実行速度計測
            //

            {
                long start = System.currentTimeMillis();
                for (int i=0; i<1000; i++) {
                    //doc.deepCopy();
                    doc = t.getDocument();
                }
                long time = System.currentTimeMillis() - start;
                System.out.println("ドキュメントのコピー:"+(time/1000F)+"ms");
            }

            /*{
                long start = System.currentTimeMillis();
                for (int i=0; i<1000; i++) {
                    HTMLNode test = doc.find("html/body/div/div/div/div/div/div/div/div/div/div/div");
                }
                long time = System.currentTimeMillis() - start;
                System.out.println("XPath:html/body/div/div/div/div/div/div/div/div/div/div/div "+(time/1000F)+"ms");
            }*/

            try {
                long start = System.currentTimeMillis();
                for (int i=0; i<100; i++) {
                    HTMLNode test = doc.find("//*[@id=\"test\"]");
                }
                long time = System.currentTimeMillis() - start;
                System.out.println("HTMLDocument#find(XPath ID検索):"+(time/100F)+"ms");
            }
            catch (NodeNotFoundException ex) {
            }

            try {
                long start = System.currentTimeMillis();
                for (int i = 0; i < 10000; i++) {
                    HTMLNode test = doc.findElement("test");
                }
                long time = System.currentTimeMillis() - start;
                System.out.println("CompositeNode#findElement(IDで検索):" + (time / 10000F) + "ms");
            }
            catch (NodeNotFoundException ex) {
            }

            {
                long start = System.currentTimeMillis();
                for (int i = 0; i < 10000; i++) {
                    HTMLNodeList test = NodeSelector.selectElementsByClass(new NodeTreeIterator(doc), "cls_a");
                }
                long time = System.currentTimeMillis() - start;
                System.out.println("NodeSelector.selectElementsByClass:" + (time / 10000F) + "ms");
            }

            {
                long start = System.currentTimeMillis();
                for (int i = 0; i < 1000; i++) {
                    doc.toHTML();
                }
                long time = System.currentTimeMillis() - start;
                System.out.println("HTMLDocument#toHTML:" + (time / 1000F) + "ms");
            }
            System.out.println("ノード数:"+doc.count());


            /*HTMLTemplate t = TemplateLoader.load(new File("d:\\var\\tmp\\so-net.html"), null);
            HTMLTagNode doc = t.getDocument();

            // テキストの追加
            HTMLTagNode html = doc.getChildren().getTag("html");
            //HTMLTagNode head = doc.getChildren().getTag("html").getChildren().getTag("head");
            HTMLTagNode head = doc.findTag("/html/head");
            HTMLTagNode title = head.getChildren().getTag("title");
            title.addText(" - タイトルに文字列追加</title>");

            // タグの追加
            //HTMLTagNode memo = doc.findTagById("memo");
            HTMLTagNode memo = doc.findTag(".//*[@id=\"test\"]");
            HTMLTagNode p = new HTMLTagNode("p", true);
            p.setText("--- 追加したタグ ---");
            memo.getChildren().add(0, p);

            HTMLTagNode meta = head.getChildren().getTag("meta", 4);
            meta.setAttribute("content", "--- パーサのテスト ---");

            // XPathのテスト

            // ドキュメントルート
            HTMLTagNode root_head = memo.findTag("/html/head");
            // 複数ノード
            HTMLTagNode multiple = doc.findTag(".//div");
            HTMLTagNode multi_a = doc.findTag(".//a");
            //Iterator it = doc.findTags(".//a");
            // アトリビュート
            HTMLTagNode attr = doc.findTag("html/@lang");
            String lang = root_head.findTag("/html").getAttribute("lang");

            System.out.println(doc.toHTML());
            */

            /*{
                long start = System.currentTimeMillis();
                for (int i=0; i<1000; i++) {
                    //doc.deepCopy();
                    doc = t.getDocument();
                }
                long time = System.currentTimeMillis() - start;
                System.out.println("ドキュメントのコピー:"+(time/1000F)+"ms");
            }

            {
                long start = System.currentTimeMillis();
                for (int i=0; i<1000; i++) {
                    HTMLTagNode test = doc.findTag("html/body/div/div/div/div/div/div/div/div/div/div/div");
                }
                long time = System.currentTimeMillis() - start;
                System.out.println("XPath:html/body/div/div/div/div/div/div/div/div/div/div/div "+(time/1000F)+"ms");
            }

            {
                long start = System.currentTimeMillis();
                for (int i=0; i<100; i++) {
                    HTMLTagNode test = doc.findTag(".//*[@id=\"test\"]");
                }
                long time = System.currentTimeMillis() - start;
                System.out.println("XPath ID検索:"+(time/100F)+"ms");
            }

            {
                long start = System.currentTimeMillis();
                for (int i = 0; i < 1000; i++) {
                    HTMLTagNode test = doc.findTagById("test");
                }
                long time = System.currentTimeMillis() - start;
                System.out.println("findTagById:" + (time / 1000F) + "ms");
            }

            {
                long start = System.currentTimeMillis();
                for (int i = 0; i < 1000; i++) {
                    doc.toHTML();
                }
                long time = System.currentTimeMillis() - start;
                System.out.println("toHTML:" + (time / 1000F) + "ms");
            }*/
            //System.out.println("ノード数:"+doc.count());

            /*NekoHTMLTemplate template = TemplateLoader.load(new File("d:\\var\\tmp\\so-net.html"));
            Document doc = template.getDocument();
            print(doc, "  ");*/
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
    public static void print(Node node, String indent) {
        System.out.println(indent+node.getClass().getName());
        Node child = node.getFirstChild();
        while (child != null) {
            print(child, indent+" ");
            child = child.getNextSibling();
        }
    } // print(Node)
}

