/*
 * $Id: GetLog.java 223 2007-10-14 08:07:40Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日： 2005/03/11
 */
package feat2.testapp.flash;

import java.util.ArrayList;

import feat2.CommandContext;
import feat2.Fetcher;

/**
 * チャットログを取得する。
 * @author SUGIMOTO
 */
public class GetLog implements Fetcher {

    private int index;


    public Object execute(CommandContext ctx) throws Exception {

        if ( index < -10 )
            index = -10;
        if ( index < ChatLog.getNextIndex()-10 )
            index = ChatLog.getNextIndex()-10;

        ArrayList msgs = new ArrayList();

        if ( index < 0 ) {
            for(; index < 0; index++) {
                ChatMessage m = ChatLog.getMessage(index);
                if ( m != null )
                    msgs.add(m);

            }
        }
        else {
            for(; index<ChatLog.getNextIndex(); index++) {
                ChatMessage m = ChatLog.getMessage(index);
                if ( m != null )
                    msgs.add(m);
            }
        }

        return msgs;

    }


    public void setIndex(int index) {
        this.index = index;
    }

}
