/*
 * $Id: Dependencies.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 作成日: 2006/03/06
 */
package feat2.config;

import java.util.ArrayList;

class Dependencies {

    private ArrayList dependencies;

    Dependencies() {
        dependencies = new ArrayList();
    }

    /**
     * 依存関係を追加する。from, to両方のオブジェクトとその関係が登録される。
     * @param from
     * @param to
     */
    void addDependency(Object from, Object to) {
        Dependency d = getDependency(from);
        if ( d == null ) {
            d = new Dependency(from);
            dependencies.add(d);
        }
        d.addDepend(to);

        // 依存先のオブジェクトの

        getDependency(to);
    }

    private Dependency getDependency(Object o) {
        for(int i=0; i<dependencies.size(); i++) {
            Dependency d = (Dependency)dependencies.get(i);
            if ( d.obj == o )
                return d;
        }
        return null;
    }

    /**
     * 指定のオブジェクトの依存先、オブジェクトへの依存を削除する。
     * @param o
     */
    void removeDependencies(Object o) {
        Dependency rem = null;

        // 他のオブジェクトからの依存性を削除する
        for(int i=0; i<dependencies.size(); i++) {
            Dependency d = (Dependency)dependencies.get(i);
            d.removeDepend(o);
            if ( d.obj == o )
                rem = d;
        }

        // このオブジェクトからの依存性を削除
        if ( rem != null )
            dependencies.remove(rem);
    }

    /**
     * どのオブジェクトにも依存しないオブジェクトを一つ返す。
     * @return
     */
    Object getIndependentObject() {
        for(int i=0; i<dependencies.size(); i++) {
            Dependency d = (Dependency)dependencies.get(i);
            if ( d.countDepends() == 0 )
                return d.obj;
        }
        return null;
    }

    int count() {
        return dependencies.size();
    }

}