/*
 * $Id: IdentifierList.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 作成日: 2006/03/08
 */
package feat2.config.type;

import feat2.StringUtil;

/**
 * featの識別子のリスト(ホワイトスペース区切り)。
 * @author SUGIMOTO Ken-ichi
 */
public class IdentifierList {

    private Identifier[] identifiers;

    public IdentifierList(String names) {

        String[] nameList = StringUtil.split(names);
        identifiers = new Identifier[nameList.length];

        for (int i = 0; i < nameList.length; i++) {
            identifiers[i] = new Identifier(nameList[i]);
        }

    }

    public int size() {
        return identifiers.length;
    }

    public Identifier get(int index) {
        return identifiers[index];
    }

    public Identifier[] getAll() {
        Identifier[] ret = new Identifier[identifiers.length];
        System.arraycopy(identifiers, 0, ret, 0, ret.length);
        return ret;
    }

}
