﻿/*
 * $Revision: 223 $ $Date: 2007-10-14 17:07:40 +0900 $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 */

import feat2.ServiceDelegate;
import feat2.Future;
import feat2.CommandObserver;
import feat2.ObjectObserver;
import chat.*;

class chat.ChatAction {

    private var view_:ChatView;
    private var model_:ChatModel;
    private var delegate_:ServiceDelegate;

    function getView():ChatView {
        return view_;
    }
    function setView(v:ChatView):Void {
        view_ = v;
    }


    function getModel():ChatModel {
        return model_;
    }
    function setModel(m:ChatModel):Void {
        model_ = m;
        _root.debug("setModel");
    }


    function getDelegate():ServiceDelegate {
        return delegate_;
    }
    function setDelegate(d:ServiceDelegate):Void {
        _root.bp();
        _root.debug("setDelegate");
        delegate_ = d;
    }


    function sendMessage(username:String, message:String):Void {
        _root.bp();
        if ( message == null || message == "" )
            return;

        var ob:CommandObserver = new ObjectObserver({
            action:this,
            done:function(future:Future) {
                this.action.getLog();
            },
            error:function(future:Future) {
                if ( future.getErrorCode() != "timeout" )
                    this.action.getView().showErrorScreen(future.getErrorCode(), future.getErrorMessage());
            }
        });

        delegate_.executeObject("test", "send_message", {username:username, message:message}, ob);
        view_.clearInputText();
    }

    function getLog():Void {
        var ob:CommandObserver = new ObjectObserver({
            action:this,
            done:function(future:Future) {
                var res = future.getResponse(null);
                if ( res != null && res.length > 0 ) {
                    for(var i=0; i<res.length; i++) {
                        var m = res[i];
                        if ( m.index > this.action.getModel().getIndex() ) {
                            this.action.getView().addMessage(m);
                            this.action.getModel().setIndex(m.index);
                        }
                    }
                }
            },
            error:function(future:Future) {
                if ( future.getErrorCode() != "timeout" )
                    this.action.getView().showErrorScreen(future.getErrorCode(), future.getErrorMessage());
            }
        });

        delegate_.executeObject("test", "get_log", {index:model_.getIndex()+1}, ob);
    }

}