﻿/*
 * $Revision: 223 $ $Date: 2007-10-14 17:07:40 +0900 $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 */

import feat2.*;
import chat.*;

class chat.ChatView {
	
	private var inputText:TextField;
	private var logText:TextField;
	private var err:ErrorScreen;
	private var model_:ChatModel;
	
	function ChatView(input:TextField, log:TextField, err:ErrorScreen) {
		inputText = input;
		logText = log;
		this.err = err;
		var f:TextFormat = logText.getNewTextFormat();
		f.tabStops = [80, 120, 160];
		logText.setNewTextFormat(f);
	}
	
	function clearInputText():Void {
		inputText.text = "";
	}
	
	function setModel(m:ChatModel):Void {
		model_ = m;
	}
	
	function showErrorScreen(errorCode:String, message:String):Void {
		err.show("errorCode:"+errorCode+"\rmessage:"+message);
	}

	function addMessage(m:Object):Void {
		logText.text += m.username + "\t" + m.message + " (" +
				m.date.getFullYear()+"/"+m.date.getMonth()+"/"+m.date.getDate()+" " +
				m.date.getHours()+":"+m.date.getMinutes() + ")\r";
		if ( logText.scroll < logText.maxscroll ) {
			logText.scroll = logText.maxscroll;
		}
	}
}
