/**
 * FeedBlog MixiWrapper
 *
 * @copyright 2009 FeedBlog Project (http://sourceforge.jp/projects/feedblog/)
 * @author Kureha Hisame (http://lunardial.sakura.ne.jp/) & Yui Naruse (http://airemix.com/)
 * @since 2009/06/03
 * @version 3.0.0.0
 */
// ログのリストが書かれたXMLのファイルパスを記入してください
var logXmlUrl = "./xml/loglist.xml";
// Feex XMLの<content>要素で、<br>を使用しているか？
var inputValidateMode = 0;

// フィードの基本情報を記録する変数
var feedInfo;
// 記事リストを格納する変数
var entryList;
// 現在編集中の記事の位置を示す変数
var viewIndex;
// コンボボックスの横幅を指定します
var comboWidth = 300;

/**
 * 全DOMが使用可能になり次第、自動的に呼ばれる関数
 */
function initLoad(){
    logXMLLoader();
}

/**
 * ログファイル選択用のコンボボックスをid名:logSelecterに生成します
 */
function logXMLLoader(){
    // ログ用のXMLを読み込みます
    jQuery.ajax({
        url: logXmlUrl,
        method: "GET",
        // error: showError,
        success: function(xmlData){
            var separateTag = xmlData.getElementsByTagName("file");
            var fileList = new Array(separateTag.length);
            var initUrl;
            
            // 読み込んだ要素をStoreに格納して表示
            var boxBuffer = [];
            boxBuffer.push("<form name='logform'><select name='logbox' style='width: " + comboWidth + "px' onchange='xmlLoader(this.options[this.selectedIndex].value)'>");
            for (var i = 0; i < separateTag.length; i++) {
                if (i == 0) {
                    initUrl = separateTag[i].getElementsByTagName("path")[0].firstChild.nodeValue;
                }
                boxBuffer.push("<option value='" + separateTag[i].getElementsByTagName("path")[0].firstChild.nodeValue + "'/>" + separateTag[i].getElementsByTagName("display")[0].firstChild.nodeValue + " (" + separateTag[i].getElementsByTagName("path")[0].firstChild.nodeValue + ")" + "</option>");
            }
            boxBuffer.push("</select></form>");
            
            // コンボボックス要素を生成
            document.getElementById("logSelecter").innerHTML = boxBuffer.join("");
            
            // 最新の日記をローディングする
            xmlLoader(initUrl);
        }
    });
}

/**
 * URLを指定し、指定されたFeedXmlを読み込み、解析を行います
 * @param {String} url
 */
function xmlLoader(url){
    // 日記本体のデータをローディングする
    var loader = new jQuery.ajax({
        url: url,
        method: "GET",
        error: showError,
        success: analyzeTargetXml
    });
}

/**
 * 引数に存在するXMLデータを解析し、画面に反映します
 * @param {Object} xmlData
 */
function analyzeTargetXml(xmlData){
    var rootTag = xmlData.getElementsByTagName("feed");
    var entryTag = xmlData.getElementsByTagName("entry");
    
    // グローバル変数を初期化
    feedInfo = null;
    entryList = [];
    
    for (var i = 0; i < entryTag.length; i++) {
        entryList.push(new Entry(entryTag[i]));
    }
    
    refleshEntrylistBox();
    entryLoader(0);
}

/**
 * HTMLの内容をFeedInfoに変換します
 */
function applyFeedinfo(){
    var finfo = new Object();
    finfo.title = document.getElementById("feed_title").value;
    finfo.subtitle = document.getElementById("feed_subtitle").value;
    finfo.self = document.getElementById("feed_self").value;
    finfo.alternate = document.getElementById("feed_alternate").value;
    finfo.id = document.getElementById("feed_id").value;
    finfo.rights = document.getElementById("feed_rights").value;
    finfo.authorname = document.getElementById("feed_authorname").value;
    finfo.authoremail = document.getElementById("feed_authoremail").value;
    
    return finfo;
}

/**
 * 指定したEntryList上のインデックスの記事をロードします
 * @param {int} index
 */
function entryLoader(index){
    document.getElementById("entry_title").value = entryList[index].title;
    document.getElementById("entry_stdin").value = validateText(entryList[index].content);
    viewIndex = index;
}

/**
 * 記事一覧の情報を表示するセレクトボックスにentryListの情報を反映させます
 */
function refleshEntrylistBox(){
    var stringBuffer = [];
    stringBuffer.push("<form name='logform'><select id='logBox' style='width: " + comboWidth + "px' onchange='entryLoader(this.options[this.selectedIndex].value)'>");
    for (var i = 0; i < entryList.length; i++) {
        stringBuffer.push("<option value='" + i + "'/>" + entryList[i].title + "</option>");
    }
    stringBuffer.push("</select></form>");
    // コンボボックス要素を生成
    document.getElementById("entrySelect").innerHTML = stringBuffer.join("");
}

/**
 * Feed基本情報保持クラス
 * @param {Object} obj
 */
function FeedInfo(obj){
    this.title = xmlAttrContentUnescape($("title:first", obj).text());
    this.subtitle = xmlAttrContentUnescape($("subtitle:first", obj).text());
    this.self = xmlAttrContentUnescape($("link[rel=self]", obj).attr("href"));
    this.alternate = xmlAttrContentUnescape($("link[rel=alternate]", obj).attr("href"));
    this.updated = xmlAttrContentUnescape($("updated:first", obj).text());
    this.id = xmlAttrContentUnescape($("id:first", obj).text());
    this.rights = xmlAttrContentUnescape($("rights:first", obj).text());
    this.authorname = xmlAttrContentUnescape($("author>name", obj).text());
    this.authoremail = xmlAttrContentUnescape($("author>email", obj).text());
}

/**
 * 記事クラス
 * @param {Object} obj entry 要素の DOM オブジェクト
 */
function Entry(obj){
    this.id = xmlAttrContentUnescape($("id:first", obj).text());
    this.title = xmlAttrContentUnescape($("title:first", obj).text());
    this.summary = xmlAttrContentUnescape($("summary:first", obj).text());
    this.published = xmlAttrContentUnescape($("published:first", obj).text());
    this.updated = xmlAttrContentUnescape($("updated:first", obj).text());
    this.link = xmlAttrContentUnescape($("link:first", obj).attr("href"));
    this.content = xmlAttrContentUnescape($("content:first", obj).text());
    
    if (inputValidateMode == 0) {
        this.content = this.content.replace(/[\r\n]|\r\n/g, "");
        this.content = this.content.replace(/<br>/ig, "\n");
    }
}

/**
 * 日記本文のバリデーション処理を行います
 * @param {String} contents 日記の本文が格納されている文字列
 */
function validateText(contents){
    // 置換に使用する変数
    var target_tag;
    var target_element;
    
    // ニコニコ動画のタグを置換
    while (target_tag = contents.match(/<iframe[^>]*src=["']http:\/\/ext.nicovideo.jp\/thumb\/sm\d*["'][^>]*>[^<]*<\/iframe>/i)) {
        // src="..."の部分だけ抜き出す
        target_element = target_tag[0].match(/src=["'][^"']*["']/i);
        target_element = '&lt;externalvideo src=&quot;NC:' + target_element[0].replace(/src=["']http:\/\/ext.nicovideo.jp\/thumb\/|["']/ig, "") + ':D&quot;&gt;';
        // iframeタグ全体を置換する
        contents = contents.replace(target_tag, target_element);
    }
    
    // Aタグを変換する
    /*
     var base_uri = document.location.href.replace(/[^\/]+$/, '');
     var func = function(target, quote, url){
     // 相対URIが検出された場合、フルに置換する
     return '( ' + url.replace(/^(?!http)(?:\.\/)?/, base_uri) + ' )';
     };
     contents = contents.replace(/<a[^>]*href=(["'])(.*?)\1[^>]*>.*?<\/a>/i, func);
     */
    // Aタグを変換する
    while (contents.match(/<a[^>]*>/)) {
        // 置換対象のAタグを抽出する
        target_tag = contents.match(/<a[^>]*>/i);
        // href="..."の部分のみを抜き出す
        target_element = target_tag[0].match(/href=["'][^"']*["']/i);
        // 相対URIが検出された場合、フルに置換する
        var baseUri = document.location.href.replace(/[^\/]+$/, '');
        target_element = target_element[0].replace(/\.\//, baseUri).replace(/\.\.\//g, "");
        // Aタグ全体を消去し、再度Aクローズタグの置換を行う
        contents = contents.replace(target_tag, "");
        contents = contents.replace(/<\/a>/i, " ( " + target_element.replace(/href=|["']/g, "") + " ) ");
    }
    
    // ブロック要素のタグが存在した場合、改行をその後に挿入します。
    if (document.getElementById("isCoverBlockTag").checked) {
        contents = contents.replace(/<(div|h\d|p)[^>]*>/ig, "-----------------------------------------------------------------------------\n");
        contents = contents.replace(/(\n|)<\/(div|h\d|p)>/ig, "\n-----------------------------------------------------------------------------\n");
    }
    else {
        contents = contents.replace(/<\/(div|h\d|p)>/ig, "\n");
    }
    
    // 通常のタグすべてを削除する
    contents = contents.replace(/<[^>]*>|<\/[^>]*>/ig, "");
    
    // 通常のタグ置換後、ニコニコ動画のタグを元に戻す
    contents = contents.replace(/&lt;externalvideo src=&quot;NC:/g, "<externalvideo src='NC:");
    contents = contents.replace(/:D&quot;&gt;/, ":D'>");
    
    // 半角を置換する
    contents = contents.replace(/&nbsp;/g, " ");
    
    return contents;
}

/**
 * エラーメッセージを表示するメソッドです
 */
function showError(){
    alert("XMLファイルが読み込めません！パスの設定を確認してください。");
}

/**
 * XMLのエスケープを行う関数
 * @param {String} str エスケープを行う文字列
 */
function xmlAttrContentEscape(str){
    return str.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;').replace(/^[ ]+/mg, "&nbsp;").replace(/^[\t]+/mg, "");
}

/**
 * XMLの逆エスケープを行う関数
 * @param {String} str 逆エスケープを行う文字列
 */
function xmlAttrContentUnescape(str){
    return str.replace(/^[\t]+/mg, "").replace(/^[ ]+/mg, "&nbsp;").replace(/&quot;/g, '"').replace(/&gt;/g, ">").replace(/&lt;/g, "<").replace(/&amp;/g, "&");
}
