#!/usr/bin/env ruby
=begin
  2009/09/16
  felicabalanceviewer.rb ver. 0.0.2
  copyright(c) 2009 A&C Company
=end

require 'gtk2'
require 'pasori'

class FelicaInfo

  attr_reader :idm
  attr_reader :type
  attr_reader :bal
  
  def initialize
    #puts "begin initialize"
    @idm = nil
    @type = ""
    @bal = 0
    begin
      Pasori.open {|pasori|
        get_info(pasori)
      }
    rescue => exc
      # failed to open pasori
      # p exc
      raise exc
    end
    
    #puts "end initialize"
  end

  def get_info(pasori)
    begin
      pasori.felica_polling(Felica::POLLING_EDY) {|felica|
        @idm = felica.idm
        get_edy(felica) || get_nanaco(felica) || get_waon(felica) || raise("unknown card")
      }
    rescue => exc
      # p exc
      begin
        #puts "try suica"
        pasori.felica_polling(Felica::POLLING_SUICA) {|felica|
          @idm = felica.idm
          get_suica(felica) || raise("unknown card")
      }
      rescue => exc
        # p exc
        @idm = nil
        return false
      end
    end
    return true
  end

  def get_edy(felica) 
    begin
      b = felica.read(0x170f, 0)
      @bal = (b[14] << 8) + b[15]
      # p @bal
      @type = "Edy"
    rescue
      return false
    end
    return true
  end
  
  def get_suica(felica)
    begin
      b = felica.read(0x090f, 0)
      @bal = (b[11] << 8) + b[10];
      #p @bal
      @type = "Suica"
    rescue
      return false
    end
    return true
  end
  
  def get_nanaco(felica)
    begin
      b = felica.read(0x564f, 0)
      @bal = (b[7] << 8) + b[8];
      @type = "nanaco";
    rescue
      return false
    end
    return true
  end

  def get_waon(felica)
    begin
      seq = -1
      for pos in [ 0, 1, 2 ]
        begin
          b = felica.read(0x680b, (pos)*2)
          newSeq = (b[13] << 8) + b[14]
          if seq > newSeq then
            pos = pos-1
            break
          end
            seq = newSeq
        rescue
          break
        end
      end
      b = felica.read(0x680b, pos*2+1)
      
      @bal = bal = ((b[5] & 0x1f) << 11) + (b[6] << 3) + (b[7] >> 5)
      @type = "WAON";
    rescue
      return false
    end
    return true
  end
end




box = Gtk::VBox.new(false, 0)
labelt = Gtk::Label.new("labelt")
labelb = Gtk::Label.new("labelb")

window = Gtk::Window.new("balance")
#window.signal_connect("delete_event") {
#  puts "delete event occurred"
#  #true
#  false
#}

window.signal_connect("destroy") {
#  puts "destroy event occurred"
  Gtk.main_quit
}

window.border_width = 10
window.add(box)

box.pack_start(labelt, true, true, 0)
box.pack_start(labelb, true, true, 0)

window.show_all


Thread.start do
  while true
    f = FelicaInfo.new
    if f.idm then
      labelt.text = f.type
      labelb.text = format("%d", f.bal)
    else
      labelt.text = ""
      labelb.text = ""
    end
    sleep 1
  end

end

Gtk.main
#puts "end"
