/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dataset.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.seasar.extension.dataset.ColumnType;
import org.seasar.extension.dataset.DataReader;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataSetConstants;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.impl.DataSetImpl;
import org.seasar.extension.dataset.types.ColumnTypes;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.util.Base64Util;
import org.seasar.framework.util.FileInputStreamUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.TimestampConversionUtil;

public class XlsReader
implements DataReader,
DataSetConstants {
    protected DataSet dataSet;
    protected HSSFWorkbook workbook;
    protected HSSFDataFormat dataFormat;
    protected boolean trimString = true;

    public XlsReader(String path) {
        this(path, true);
    }

    public XlsReader(String path, boolean trimString) {
        this(ResourceUtil.getResourceAsStream((String)path), trimString);
    }

    public XlsReader(String dirName, String fileName) {
        this(dirName, fileName, true);
    }

    public XlsReader(String dirName, String fileName, boolean trimString) {
        this(ResourceUtil.getResourceAsFile((String)dirName), fileName, trimString);
    }

    public XlsReader(File dir, String fileName) {
        this(dir, fileName, true);
    }

    public XlsReader(File dir, String fileName, boolean trimString) {
        this(new File(dir, fileName), trimString);
    }

    public XlsReader(File file) {
        this(file, true);
    }

    public XlsReader(File file, boolean trimString) {
        this(FileInputStreamUtil.create((File)file));
    }

    public XlsReader(InputStream in) {
        this(in, true);
    }

    public XlsReader(InputStream in, boolean trimString) {
        this.trimString = trimString;
        try {
            this.workbook = new HSSFWorkbook(in);
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
        this.dataFormat = this.workbook.createDataFormat();
        this.dataSet = new DataSetImpl();
        for (int i = 0; i < this.workbook.getNumberOfSheets(); ++i) {
            this.createTable(this.workbook.getSheetName(i), this.workbook.getSheetAt(i));
        }
    }

    public DataSet read() {
        return this.dataSet;
    }

    protected DataTable createTable(String sheetName, HSSFSheet sheet) {
        DataTable table = this.dataSet.addTable(sheetName);
        int rowCount = sheet.getLastRowNum();
        if (rowCount > 0) {
            this.setupColumns(table, sheet);
            this.setupRows(table, sheet);
        } else if (rowCount == 0) {
            this.setupColumns(table, sheet);
        }
        return table;
    }

    protected void setupColumns(DataTable table, HSSFSheet sheet) {
        String columnName;
        HSSFCell nameCell;
        HSSFRow nameRow = sheet.getRow(0);
        HSSFRow valueRow = sheet.getRow(1);
        for (int i = 0; i <= Short.MAX_VALUE && (nameCell = nameRow.getCell((short)i)) != null && (columnName = nameCell.getRichStringCellValue().getString()).length() != 0; ++i) {
            HSSFCell valueCell = null;
            if (valueRow != null) {
                for (int j = 1; j <= sheet.getLastRowNum() && (valueCell = sheet.getRow(j).getCell((short)i)) == null; ++j) {
                }
            }
            if (valueCell != null) {
                table.addColumn(columnName, this.getColumnType(valueCell));
                continue;
            }
            table.addColumn(columnName);
        }
    }

    protected void setupRows(DataTable table, HSSFSheet sheet) {
        HSSFRow row;
        for (int i = 1; i <= 65535 && (row = sheet.getRow(i)) != null; ++i) {
            this.setupRow(table, row);
        }
    }

    protected void setupRow(DataTable table, HSSFRow row) {
        DataRow dataRow = table.addRow();
        for (int i = 0; i < table.getColumnSize(); ++i) {
            HSSFCell cell = row.getCell((short)i);
            Object value = this.getValue(cell);
            dataRow.setValue(i, value);
        }
    }

    public boolean isCellBase64Formatted(HSSFCell cell) {
        HSSFCellStyle cs = cell.getCellStyle();
        short dfNum = cs.getDataFormat();
        return "\\B\\:@".equals(this.dataFormat.getFormat(dfNum));
    }

    public boolean isCellDateFormatted(HSSFCell cell) {
        HSSFCellStyle cs = cell.getCellStyle();
        short dfNum = cs.getDataFormat();
        String format = this.dataFormat.getFormat(dfNum);
        if (StringUtil.isEmpty((String)format)) {
            return false;
        }
        return format.indexOf(47) > 0 || format.indexOf(121) > 0 || format.indexOf(109) > 0 || format.indexOf(100) > 0;
    }

    public Object getValue(HSSFCell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case 0: {
                if (this.isCellDateFormatted(cell)) {
                    return TimestampConversionUtil.toTimestamp((Object)cell.getDateCellValue());
                }
                double numericCellValue = cell.getNumericCellValue();
                if (this.isInt(numericCellValue)) {
                    return new BigDecimal((int)numericCellValue);
                }
                return new BigDecimal(Double.toString(numericCellValue));
            }
            case 1: {
                String s = cell.getRichStringCellValue().getString();
                if (s != null) {
                    s = StringUtil.rtrim((String)s);
                    if (!this.trimString && s.length() > 1 && s.startsWith("\"") && s.endsWith("\"")) {
                        s = s.substring(1, s.length() - 1);
                    }
                }
                if ("".equals(s)) {
                    s = null;
                }
                if (this.isCellBase64Formatted(cell)) {
                    return Base64Util.decode((String)s);
                }
                return s;
            }
            case 4: {
                boolean b = cell.getBooleanCellValue();
                return b;
            }
        }
        return null;
    }

    protected ColumnType getColumnType(HSSFCell cell) {
        switch (cell.getCellType()) {
            case 0: {
                if (this.isCellDateFormatted(cell)) {
                    return ColumnTypes.TIMESTAMP;
                }
                return ColumnTypes.BIGDECIMAL;
            }
            case 4: {
                return ColumnTypes.BOOLEAN;
            }
            case 1: {
                if (this.isCellBase64Formatted(cell)) {
                    return ColumnTypes.BINARY;
                }
                if (this.trimString) {
                    return ColumnTypes.STRING;
                }
                return ColumnTypes.NOT_TRIM_STRING;
            }
        }
        return ColumnTypes.STRING;
    }

    protected boolean isInt(double numericCellValue) {
        return (double)((int)numericCellValue) == numericCellValue;
    }
}

