/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.tartarus.snowball.SnowballProgram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnowballPorterFilterFactory
extends BaseTokenFilterFactory {
    private String language = "English";
    private Class stemClass;

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        String cfgLanguage = args.get("language");
        if (cfgLanguage != null) {
            this.language = cfgLanguage;
        }
        try {
            this.stemClass = Class.forName("org.tartarus.snowball.ext." + this.language + "Stemmer");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Can't find class for stemmer language " + this.language, e);
        }
    }

    public SnowballFilter create(TokenStream input) {
        SnowballProgram program;
        try {
            program = (SnowballProgram)this.stemClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating stemmer for language " + this.language + "from class " + this.stemClass, e);
        }
        return new SnowballFilter(input, program);
    }
}

