/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import org.apache.solr.analysis.TokenFilterFactory;
import org.apache.solr.analysis.TokenizerFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.request.QueryResponseWriter;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.schema.FieldType;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.solr.util.plugin.ResourceLoaderAware;
import org.apache.solr.util.plugin.SolrCoreAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolrResourceLoader
implements ResourceLoader {
    public static final Logger log = Logger.getLogger(SolrResourceLoader.class.getName());
    static final String project = "solr";
    static final String base = "org.apache.solr";
    static final String[] packages = new String[]{"", "analysis.", "schema.", "handler.", "search.", "update.", "core.", "request.", "update.processor.", "util.", "spelling.", "handler.component."};
    private final ClassLoader classLoader;
    private final String instanceDir;
    private String dataDir;
    private final List<SolrCoreAware> waitingForCore = new ArrayList<SolrCoreAware>();
    private final List<ResourceLoaderAware> waitingForResources = new ArrayList<ResourceLoaderAware>();
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final Properties coreProperties;
    private static final Map<Class, Class[]> awareCompatibility = new HashMap<Class, Class[]>();

    public SolrResourceLoader(String instanceDir, ClassLoader parent, Properties coreProperties) {
        this.instanceDir = instanceDir == null ? SolrResourceLoader.locateInstanceDir() : SolrResourceLoader.normalizeDir(instanceDir);
        log.info("Solr home set to '" + this.instanceDir + "'");
        this.classLoader = SolrResourceLoader.createClassLoader(new File(this.instanceDir + "lib/"), parent);
        this.coreProperties = coreProperties;
    }

    public SolrResourceLoader(String instanceDir, ClassLoader parent) {
        this(instanceDir, parent, null);
    }

    static ClassLoader createClassLoader(File f, ClassLoader loader) {
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (f.canRead() && f.isDirectory()) {
            File[] jarFiles = f.listFiles();
            URL[] jars = new URL[jarFiles.length];
            try {
                for (int j = 0; j < jarFiles.length; ++j) {
                    jars[j] = jarFiles[j].toURI().toURL();
                    log.info("Adding '" + jars[j].toString() + "' to Solr classloader");
                }
                return URLClassLoader.newInstance(jars, loader);
            }
            catch (MalformedURLException e) {
                SolrException.log((Logger)log, (String)"Can't construct solr lib class loader", (Throwable)e);
            }
        }
        log.info("Reusing parent classloader");
        return loader;
    }

    public SolrResourceLoader(String instanceDir) {
        this(instanceDir, null, null);
    }

    public static String normalizeDir(String path) {
        return path != null && !path.endsWith("/") && !path.endsWith("\\") ? path + '/' : path;
    }

    public String getConfigDir() {
        return this.instanceDir + "conf/";
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public Properties getCoreProperties() {
        return this.coreProperties;
    }

    public InputStream openSchema(String name) {
        return this.openResource(name);
    }

    public InputStream openConfig(String name) {
        return this.openResource(name);
    }

    public InputStream openResource(String resource) {
        InputStream is = null;
        try {
            File f0;
            File f = f0 = new File(resource);
            if (!f.isAbsolute()) {
                f = new File(this.getConfigDir() + resource);
            }
            if (f.isFile() && f.canRead()) {
                return new FileInputStream(f);
            }
            if (f != f0 && f0.isFile() && f0.canRead()) {
                return new FileInputStream(f0);
            }
            is = this.classLoader.getResourceAsStream(resource);
        }
        catch (Exception e) {
            throw new RuntimeException("Error opening " + resource, e);
        }
        if (is == null) {
            throw new RuntimeException("Can't find resource '" + resource + "' in classpath or '" + this.getConfigDir() + "', cwd=" + System.getProperty("user.dir"));
        }
        return is;
    }

    public List<String> getLines(String resource) throws IOException {
        return this.getLines(resource, UTF_8);
    }

    public List<String> getLines(String resource, String encoding) throws IOException {
        return this.getLines(resource, Charset.forName(encoding));
    }

    public List<String> getLines(String resource, Charset charset) throws IOException {
        BufferedReader input = null;
        input = new BufferedReader(new InputStreamReader(this.openResource(resource), charset));
        ArrayList<String> lines = new ArrayList<String>();
        String word = null;
        while ((word = input.readLine()) != null) {
            if (word.startsWith("#") || (word = word.trim()).length() == 0) continue;
            lines.add(word);
        }
        return lines;
    }

    public Class findClass(String cname, String ... subpackages) {
        if (subpackages.length == 0) {
            subpackages = packages;
        }
        try {
            return Class.forName(cname, true, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            String newName = cname;
            if (newName.startsWith(project)) {
                newName = cname.substring(project.length() + 1);
            }
            for (String subpackage : subpackages) {
                try {
                    String name = "org.apache.solr." + subpackage + newName;
                    log.finest("Trying class name " + name);
                    return Class.forName(name, true, this.classLoader);
                }
                catch (ClassNotFoundException e1) {
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error loading class '" + cname + "'", (Throwable)e, false);
        }
    }

    public Object newInstance(String cname, String ... subpackages) {
        Class clazz = this.findClass(cname, subpackages);
        if (clazz == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can not find class: " + cname + " in " + this.classLoader, false);
        }
        Object obj = null;
        try {
            obj = clazz.newInstance();
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error instantiating class: '" + clazz.getName() + "'", (Throwable)e, false);
        }
        if (obj instanceof SolrCoreAware) {
            this.assertAwareCompatibility(SolrCoreAware.class, obj);
            this.waitingForCore.add(obj);
        }
        if (obj instanceof ResourceLoaderAware) {
            this.assertAwareCompatibility(ResourceLoaderAware.class, obj);
            this.waitingForResources.add(obj);
        }
        return obj;
    }

    public void inform(SolrCore core) {
        this.dataDir = core.getDataDir();
        for (SolrCoreAware aware : this.waitingForCore) {
            aware.inform(core);
        }
        this.waitingForCore.clear();
    }

    public void inform(ResourceLoader loader) {
        for (ResourceLoaderAware aware : this.waitingForResources) {
            aware.inform(loader);
        }
        this.waitingForResources.clear();
    }

    public static String locateInstanceDir() {
        String prop;
        String home = null;
        try {
            InitialContext c = new InitialContext();
            home = (String)c.lookup("java:comp/env/solr/home");
            log.info("Using JNDI solr.home: " + home);
        }
        catch (NoInitialContextException e) {
            log.info("JNDI not configured for solr (NoInitialContextEx)");
        }
        catch (NamingException e) {
            log.info("No /solr/home in JNDI");
        }
        catch (RuntimeException ex) {
            log.warning("Odd RuntimeException while testing for JNDI: " + ex.getMessage());
        }
        if (home == null && (home = System.getProperty(prop = "solr.solr.home")) != null) {
            log.info("using system property " + prop + ": " + home);
        }
        if (home == null) {
            home = "solr/";
            log.info("solr home defaulted to '" + home + "' (could not find system property or JNDI)");
        }
        return SolrResourceLoader.normalizeDir(home);
    }

    public String getInstanceDir() {
        return this.instanceDir;
    }

    void assertAwareCompatibility(Class aware, Object obj) {
        Class[] valid = awareCompatibility.get(aware);
        if (valid == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown Aware interface: " + aware);
        }
        for (Class v : valid) {
            if (!v.isInstance(obj)) continue;
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Invalid 'Aware' object: ").append(obj);
        builder.append(" -- ").append(aware.getName());
        builder.append(" must be an instance of: ");
        for (Class v : valid) {
            builder.append("[").append(v.getName()).append("] ");
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, builder.toString());
    }

    static {
        awareCompatibility.put(SolrCoreAware.class, new Class[]{SolrRequestHandler.class, QueryResponseWriter.class, SearchComponent.class, UpdateRequestProcessorFactory.class});
        awareCompatibility.put(ResourceLoaderAware.class, new Class[]{TokenFilterFactory.class, TokenizerFactory.class, FieldType.class});
    }
}

