/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;

class HttpCommComponent {
    static Executor commExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    static HttpClient client;
    CompletionService<ShardResponse> completionService = new ExecutorCompletionService<ShardResponse>(commExecutor);
    Set<Future<ShardResponse>> pending = new HashSet<Future<ShardResponse>>();

    HttpCommComponent() {
    }

    void submit(final ShardRequest sreq, final String shard, final ModifiableSolrParams params) {
        Callable<ShardResponse> task = new Callable<ShardResponse>(){

            @Override
            public ShardResponse call() throws Exception {
                ShardResponse srsp = new ShardResponse();
                srsp.setShardRequest(sreq);
                srsp.setShard(shard);
                SimpleSolrResponse ssr = new SimpleSolrResponse();
                srsp.setSolrResponse(ssr);
                long startTime = System.currentTimeMillis();
                try {
                    String url = "http://" + shard;
                    params.remove("wt");
                    params.remove("version");
                    CommonsHttpSolrServer server = new CommonsHttpSolrServer(url, client);
                    QueryRequest req = new QueryRequest((SolrParams)params);
                    req.setMethod(SolrRequest.METHOD.POST);
                    req.setResponseParser(new BinaryResponseParser());
                    ssr.nl = ((SolrServer)server).request(req);
                }
                catch (Throwable th) {
                    srsp.setException(th);
                    if (th instanceof SolrException) {
                        srsp.setResponseCode(((SolrException)th).code());
                    }
                    srsp.setResponseCode(-1);
                }
                ssr.elapsedTime = System.currentTimeMillis() - startTime;
                return srsp;
            }
        };
        this.pending.add(this.completionService.submit(task));
    }

    ShardResponse take() {
        while (this.pending.size() > 0) {
            try {
                Future<ShardResponse> future = this.completionService.take();
                this.pending.remove(future);
                ShardResponse rsp = future.get();
                rsp.getShardRequest().responses.add(rsp);
                if (rsp.getShardRequest().responses.size() != rsp.getShardRequest().actualShards.length) continue;
                return rsp;
            }
            catch (InterruptedException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
            catch (ExecutionException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Impossible Exception", (Throwable)e);
            }
        }
        return null;
    }

    ShardResponse takeCompletedOrError() {
        while (this.pending.size() > 0) {
            try {
                Future<ShardResponse> future = this.completionService.take();
                this.pending.remove(future);
                ShardResponse rsp = future.get();
                if (rsp.getException() != null) {
                    return rsp;
                }
                rsp.getShardRequest().responses.add(rsp);
                if (rsp.getShardRequest().responses.size() != rsp.getShardRequest().actualShards.length) continue;
                return rsp;
            }
            catch (InterruptedException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
            catch (ExecutionException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Impossible Exception", (Throwable)e);
            }
        }
        return null;
    }

    void cancelAll() {
        for (Future<ShardResponse> future : this.pending) {
            future.cancel(true);
        }
    }

    static {
        MultiThreadedHttpConnectionManager mgr = new MultiThreadedHttpConnectionManager();
        mgr.getParams().setDefaultMaxConnectionsPerHost(20);
        mgr.getParams().setMaxTotalConnections(10000);
        client = new HttpClient((HttpConnectionManager)mgr);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleSolrResponse
    extends SolrResponse {
        long elapsedTime;
        NamedList<Object> nl;

        private SimpleSolrResponse() {
        }

        @Override
        public long getElapsedTime() {
            return this.elapsedTime;
        }

        @Override
        public NamedList<Object> getResponse() {
            return this.nl;
        }

        @Override
        public void setResponse(NamedList<Object> rsp) {
            this.nl = rsp;
        }
    }
}

