/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharArrayMap<V>
extends AbstractMap<String, V>
implements Map<String, V>,
Cloneable,
Serializable {
    private static final int INIT_SIZE = 2;
    private char[][] keys;
    private Object[] values;
    private int count;
    private final boolean ignoreCase;

    public CharArrayMap(int initialCapacity, boolean ignoreCase) {
        int size;
        this.ignoreCase = ignoreCase;
        initialCapacity += initialCapacity >> 2;
        for (size = 2; size <= initialCapacity; size <<= 1) {
        }
        this.keys = new char[size][];
        this.values = new Object[size];
    }

    public boolean ignoreCase() {
        return this.ignoreCase;
    }

    public V get(char[] key) {
        return this.get(key, 0, key.length);
    }

    public V get(char[] key, int off, int len) {
        return (V)this.values[this.getSlot(key, off, len)];
    }

    public V get(CharSequence key) {
        return (V)this.values[this.getSlot(key)];
    }

    @Override
    public V get(Object key) {
        return (V)this.values[this.getSlot(key)];
    }

    @Override
    public boolean containsKey(Object s) {
        return this.keys[this.getSlot(s)] != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.keys[i] == null || this.values[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            Object val = this.values[i];
            if (val == null || !value.equals(val)) continue;
            return true;
        }
        return false;
    }

    private int getSlot(Object key) {
        if (key instanceof char[]) {
            char[] keyc = (char[])key;
            return this.getSlot(keyc, 0, keyc.length);
        }
        return this.getSlot((CharSequence)key);
    }

    private int getSlot(char[] key, int off, int len) {
        int code = this.getHashCode(key, len);
        int pos = code & this.keys.length - 1;
        char[] key2 = this.keys[pos];
        if (key2 != null && !this.equals(key, off, len, key2)) {
            int inc = (code >> 8) + code | 1;
            while ((key2 = this.keys[pos = (code += inc) & this.keys.length - 1]) != null && !this.equals(key, off, len, key2)) {
            }
        }
        return pos;
    }

    private int getSlot(CharSequence key) {
        int code = this.getHashCode(key);
        int pos = code & this.keys.length - 1;
        char[] key2 = this.keys[pos];
        if (key2 != null && !this.equals(key, key2)) {
            int inc = (code >> 8) + code | 1;
            while ((key2 = this.keys[pos = (code += inc) & this.keys.length - 1]) != null && !this.equals(key, key2)) {
            }
        }
        return pos;
    }

    @Override
    public V put(CharSequence key, V val) {
        return this.put(((Object)key).toString(), val);
    }

    @Override
    public V put(String key, V val) {
        return this.put(key.toCharArray(), val);
    }

    @Override
    public V put(char[] key, Object val) {
        int slot;
        if (this.ignoreCase) {
            for (int i = 0; i < key.length; ++i) {
                key[i] = Character.toLowerCase(key[i]);
            }
        }
        if (this.keys[slot = this.getSlot(key, 0, key.length)] == null) {
            ++this.count;
        }
        Object prev = this.values[slot];
        this.keys[slot] = key;
        this.values[slot] = val;
        if (this.count + (this.count >> 2) >= this.keys.length) {
            this.rehash();
        }
        return (V)prev;
    }

    private boolean equals(char[] text1, int off, int len, char[] text2) {
        if (len != text2.length) {
            return false;
        }
        if (this.ignoreCase) {
            for (int i = 0; i < len; ++i) {
                if (Character.toLowerCase(text1[off + i]) == text2[i]) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (text1[off + i] == text2[i]) continue;
                return false;
            }
        }
        return true;
    }

    private boolean equals(CharSequence text1, char[] text2) {
        int len = text1.length();
        if (len != text2.length) {
            return false;
        }
        if (this.ignoreCase) {
            for (int i = 0; i < len; ++i) {
                if (Character.toLowerCase(text1.charAt(i)) == text2[i]) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (text1.charAt(i) == text2[i]) continue;
                return false;
            }
        }
        return true;
    }

    private void rehash() {
        int newSize = 2 * this.keys.length;
        char[][] oldEntries = this.keys;
        Object[] oldValues = this.values;
        this.keys = new char[newSize][];
        this.values = new Object[newSize];
        for (int i = 0; i < oldEntries.length; ++i) {
            char[] key = oldEntries[i];
            if (key == null) continue;
            int newSlot = this.getSlot(key, 0, key.length);
            this.keys[newSlot] = key;
            this.values[newSlot] = oldValues[i];
        }
    }

    private int getHashCode(char[] text, int len) {
        int code = 0;
        if (this.ignoreCase) {
            for (int i = 0; i < len; ++i) {
                code = code * 31 + Character.toLowerCase(text[i]);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                code = code * 31 + text[i];
            }
        }
        return code;
    }

    private int getHashCode(CharSequence text) {
        int code;
        if (this.ignoreCase) {
            code = 0;
            int len = text.length();
            for (int i = 0; i < len; ++i) {
                code = code * 31 + Character.toLowerCase(text.charAt(i));
            }
        } else {
            code = 0;
            int len = text.length();
            for (int i = 0; i < len; ++i) {
                code = code * 31 + text.charAt(i);
            }
        }
        return code;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public void clear() {
        this.count = 0;
        Arrays.fill((Object[])this.keys, null);
        Arrays.fill(this.values, null);
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return new EntrySet();
    }

    public EntryIterator iterator() {
        return new EntryIterator();
    }

    @Override
    public Object clone() {
        CharArrayMap map = null;
        try {
            map = (CharArrayMap)super.clone();
            map.keys = (char[][])this.keys.clone();
            map.values = (Object[])this.values.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<String, V>> {
        private EntrySet() {
        }

        public EntryIterator iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null) {
                return false;
            }
            Object val = e.getValue();
            Object v = CharArrayMap.this.get(key);
            return v == null ? val == null : v.equals(val);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return CharArrayMap.this.count;
        }

        @Override
        public void clear() {
            CharArrayMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapEntry
    implements Map.Entry<String, V> {
        final int pos;

        MapEntry(int pos) {
            this.pos = pos;
        }

        public char[] getCharArr() {
            return CharArrayMap.this.keys[this.pos];
        }

        @Override
        public String getKey() {
            return new String(this.getCharArr());
        }

        @Override
        public V getValue() {
            return CharArrayMap.this.values[this.pos];
        }

        @Override
        public V setValue(V value) {
            Object old = CharArrayMap.this.values[this.pos];
            ((CharArrayMap)CharArrayMap.this).values[this.pos] = value;
            return old;
        }

        public String toString() {
            return this.getKey() + '=' + this.getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EntryIterator
    implements Iterator<Map.Entry<String, V>> {
        int pos = -1;
        int lastPos;

        EntryIterator() {
            this.goNext();
        }

        private void goNext() {
            this.lastPos = this.pos++;
            while (this.pos < CharArrayMap.this.keys.length && CharArrayMap.this.keys[this.pos] == null) {
                ++this.pos;
            }
        }

        @Override
        public boolean hasNext() {
            return this.pos < CharArrayMap.this.keys.length;
        }

        public char[] nextKey() {
            this.goNext();
            return CharArrayMap.this.keys[this.lastPos];
        }

        public String nextKeyString() {
            return new String(this.nextKey());
        }

        public V currentValue() {
            return CharArrayMap.this.values[this.lastPos];
        }

        public V setValue(V value) {
            Object old = CharArrayMap.this.values[this.lastPos];
            ((CharArrayMap)CharArrayMap.this).values[this.lastPos] = value;
            return old;
        }

        @Override
        public Map.Entry<String, V> next() {
            this.goNext();
            return new MapEntry(this.lastPos);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

