/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tests;

import java.util.Collection;
import java.util.HashSet;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;

public class AnnotationTest
extends TestCase {
    static boolean run;
    static int count;
    static Collection<Object> tests;
    static String log;

    public void setUp() {
        run = false;
    }

    public void testAnnotatedMethod() throws Exception {
        JUnitCore runner = new JUnitCore();
        runner.run(SimpleTest.class);
        AnnotationTest.assertTrue(run);
    }

    public void testSetup() throws Exception {
        JUnitCore runner = new JUnitCore();
        runner.run(SetupTest.class);
        AnnotationTest.assertTrue(run);
    }

    public void testTeardown() throws Exception {
        JUnitCore runner = new JUnitCore();
        runner.run(TeardownTest.class);
        AnnotationTest.assertTrue(run);
    }

    public void testRunFailure() throws Exception {
        JUnitCore runner = new JUnitCore();
        Result result = runner.run(FailureTest.class);
        AnnotationTest.assertEquals(1, result.getRunCount());
        AnnotationTest.assertEquals(1, result.getFailureCount());
        AnnotationTest.assertEquals(AssertionError.class, result.getFailures().get(0).getException().getClass());
    }

    public void testSetupFailure() throws Exception {
        JUnitCore core = new JUnitCore();
        Result runner = core.run(SetupFailureTest.class);
        AnnotationTest.assertEquals(1, runner.getRunCount());
        AnnotationTest.assertEquals(1, runner.getFailureCount());
        AnnotationTest.assertEquals(Error.class, runner.getFailures().get(0).getException().getClass());
        AnnotationTest.assertFalse(run);
    }

    public void testTeardownFailure() throws Exception {
        JUnitCore core = new JUnitCore();
        Result runner = core.run(TeardownFailureTest.class);
        AnnotationTest.assertEquals(1, runner.getRunCount());
        AnnotationTest.assertEquals(1, runner.getFailureCount());
        AnnotationTest.assertEquals(Error.class, runner.getFailures().get(0).getException().getClass());
    }

    public void testTestAndTeardownFailure() throws Exception {
        JUnitCore core = new JUnitCore();
        Result runner = core.run(TestAndTeardownFailureTest.class);
        AnnotationTest.assertEquals(1, runner.getRunCount());
        AnnotationTest.assertEquals(2, runner.getFailureCount());
        AnnotationTest.assertEquals(Exception.class, runner.getFailures().get(0).getException().getClass());
        AnnotationTest.assertEquals(Error.class, runner.getFailures().get(1).getException().getClass());
    }

    public void testTeardownAfterFailure() throws Exception {
        JUnitCore runner = new JUnitCore();
        runner.run(TeardownAfterFailureTest.class);
        AnnotationTest.assertTrue(run);
    }

    public void testTwoTests() throws Exception {
        count = 0;
        tests = new HashSet<Object>();
        JUnitCore runner = new JUnitCore();
        runner.run(TwoTests.class);
        AnnotationTest.assertEquals(2, count);
        AnnotationTest.assertEquals(2, tests.size());
    }

    public void testOldTest() throws Exception {
        JUnitCore runner = new JUnitCore();
        runner.run(OldTest.class);
        AnnotationTest.assertTrue(run);
    }

    public void testOldSuiteTest() throws Exception {
        TestSuite suite = new TestSuite((Class<? extends TestCase>)OldSuiteTest.class);
        JUnitCore runner = new JUnitCore();
        runner.run(suite);
        AnnotationTest.assertTrue(run);
    }

    public void testException() throws Exception {
        JUnitCore core = new JUnitCore();
        Result result = core.run(ExceptionTest.class);
        AnnotationTest.assertEquals(0, result.getFailureCount());
    }

    public void testExceptionNotThrown() throws Exception {
        JUnitCore core = new JUnitCore();
        Result result = core.run(NoExceptionTest.class);
        AnnotationTest.assertEquals(1, result.getFailureCount());
        AnnotationTest.assertEquals("Expected exception: java.lang.Error", result.getFailures().get(0).getMessage());
    }

    public void testOneTimeSetup() throws Exception {
        count = 0;
        JUnitCore core = new JUnitCore();
        core.run(OneTimeSetup.class);
        AnnotationTest.assertEquals(1, count);
    }

    public void testOneTimeTeardown() throws Exception {
        count = 0;
        JUnitCore core = new JUnitCore();
        core.run(OneTimeTeardown.class);
        AnnotationTest.assertEquals(1, count);
    }

    public void testOrder() throws Exception {
        log = "";
        JUnitCore core = new JUnitCore();
        core.run(OrderTest.class);
        AnnotationTest.assertEquals("beforeClass before test after afterClass ", log);
    }

    public void testNonStaticOneTimeSetup() throws Exception {
        JUnitCore core = new JUnitCore();
        Result result = core.run(NonStaticOneTimeSetup.class);
        AnnotationTest.assertEquals(1, result.getFailureCount());
    }

    public void testErrorInBeforeClass() throws Exception {
        run = false;
        JUnitCore core = new JUnitCore();
        Result result = core.run(ErrorInBeforeClass.class);
        AnnotationTest.assertFalse(run);
        AnnotationTest.assertEquals(1, result.getFailureCount());
        Description description = result.getFailures().get(0).getDescription();
        AnnotationTest.assertEquals(ErrorInBeforeClass.class.getName(), description.getDisplayName());
    }

    public void testErrorInAfterClass() throws Exception {
        run = false;
        JUnitCore core = new JUnitCore();
        Result result = core.run(ErrorInAfterClass.class);
        AnnotationTest.assertTrue(run);
        AnnotationTest.assertEquals(1, result.getFailureCount());
    }

    public void testOrderingOfInheritance() throws Exception {
        log = "";
        JUnitCore core = new JUnitCore();
        core.run(SubInheritance.class);
        AnnotationTest.assertEquals("Before class super Before class sub Before super Before sub Test After sub After super After class sub After class super ", log);
    }

    public void testShadowing() throws Exception {
        log = "";
        JUnitCore core = new JUnitCore();
        core.run(SubShadowing.class);
        AnnotationTest.assertEquals("Before sub Test After sub ", log);
    }

    public void testTestInheritance() throws Exception {
        log = "";
        JUnitCore core = new JUnitCore();
        core.run(SubTest.class);
        AnnotationTest.assertTrue(log.contains("Sub"));
        AnnotationTest.assertTrue(log.contains("Two"));
        AnnotationTest.assertFalse(log.contains("Super"));
    }

    public void testRunAllAfters() {
        log = "";
        JUnitCore core = new JUnitCore();
        core.run(RunAllAfters.class);
        AnnotationTest.assertTrue(log.contains("one"));
        AnnotationTest.assertTrue(log.contains("two"));
    }

    public void testRunAllAftersRegardless() {
        log = "";
        JUnitCore core = new JUnitCore();
        Result result = core.run(RunAllAftersRegardless.class);
        AnnotationTest.assertTrue(log.contains("one"));
        AnnotationTest.assertTrue(log.contains("two"));
        AnnotationTest.assertEquals(2, result.getFailureCount());
    }

    public void testRunAllAfterClasses() {
        log = "";
        JUnitCore core = new JUnitCore();
        core.run(RunAllAfterClasses.class);
        AnnotationTest.assertTrue(log.contains("one"));
        AnnotationTest.assertTrue(log.contains("two"));
    }

    public void testRunAllAfterClassesRegardless() {
        log = "";
        JUnitCore core = new JUnitCore();
        Result result = core.run(RunAllAfterClassesRegardless.class);
        AnnotationTest.assertTrue(log.contains("one"));
        AnnotationTest.assertTrue(log.contains("two"));
        AnnotationTest.assertEquals(2, result.getFailureCount());
    }

    public static class RunAllAfterClassesRegardless {
        @Test
        public void empty() {
        }

        @AfterClass
        public static void one() {
            log = log + "one";
            throw new Error();
        }

        @AfterClass
        public static void two() {
            log = log + "two";
            throw new Error();
        }
    }

    public static class RunAllAfterClasses {
        @Before
        public void good() {
        }

        @BeforeClass
        public static void bad() {
            throw new Error();
        }

        @Test
        public void empty() {
        }

        @AfterClass
        public static void one() {
            log = log + "one";
        }

        @AfterClass
        public static void two() {
            log = log + "two";
        }
    }

    public static class RunAllAftersRegardless {
        @Test
        public void empty() {
        }

        @After
        public void one() {
            log = log + "one";
            throw new Error();
        }

        @After
        public void two() {
            log = log + "two";
            throw new Error();
        }
    }

    public static class RunAllAfters {
        @Before
        public void good() {
        }

        @Before
        public void bad() {
            throw new Error();
        }

        @Test
        public void empty() {
        }

        @After
        public void one() {
            log = log + "one";
        }

        @After
        public void two() {
            log = log + "two";
        }
    }

    public static class SubTest
    extends SuperTest {
        @Test
        public void one() {
            log = log + "Sub";
        }
    }

    public static class SuperTest {
        @Test
        public void one() {
            log = log + "Super";
        }

        @Test
        public void two() {
            log = log + "Two";
        }
    }

    public static class SubShadowing
    extends SuperShadowing {
        @Before
        public void before() {
            log = log + "Before sub ";
        }

        @After
        public void after() {
            log = log + "After sub ";
        }

        @Test
        public void test() {
            log = log + "Test ";
        }
    }

    public static class SuperShadowing {
        @Before
        public void before() {
            log = log + "Before super ";
        }

        @After
        public void after() {
            log = log + "After super ";
        }
    }

    public static class SubInheritance
    extends SuperInheritance {
        @BeforeClass
        public static void beforeClassSub() {
            log = log + "Before class sub ";
        }

        @AfterClass
        public static void afterClassSub() {
            log = log + "After class sub ";
        }

        @Before
        public void beforeSub() {
            log = log + "Before sub ";
        }

        @After
        public void afterSub() {
            log = log + "After sub ";
        }

        @Test
        public void test() {
            log = log + "Test ";
        }
    }

    public static class SuperInheritance {
        @BeforeClass
        public static void beforeClassSuper() {
            log = log + "Before class super ";
        }

        @AfterClass
        public static void afterClassSuper() {
            log = log + "After class super ";
        }

        @Before
        public void beforeSuper() {
            log = log + "Before super ";
        }

        @After
        public void afterSuper() {
            log = log + "After super ";
        }
    }

    public static class ErrorInAfterClass {
        @Test
        public void test() {
            run = true;
        }

        @AfterClass
        public static void after() throws Exception {
            throw new Exception();
        }
    }

    public static class ErrorInBeforeClass {
        @BeforeClass
        public static void before() throws Exception {
            throw new Exception();
        }

        @Test
        public void test() {
            run = true;
        }
    }

    public static class NonStaticOneTimeSetup {
        @BeforeClass
        public void once() {
        }
    }

    public static class OrderTest {
        @BeforeClass
        public static void onceBefore() {
            log = log + "beforeClass ";
        }

        @Before
        public void before() {
            log = log + "before ";
        }

        @Test
        public void test() {
            log = log + "test ";
        }

        @After
        public void after() {
            log = log + "after ";
        }

        @AfterClass
        public static void onceAfter() {
            log = log + "afterClass ";
        }
    }

    public static class OneTimeTeardown {
        @AfterClass
        public static void once() {
            ++count;
        }

        @Test
        public void one() {
        }

        @Test
        public void two() {
        }
    }

    public static class OneTimeSetup {
        @BeforeClass
        public static void once() {
            ++count;
        }

        @Test
        public void one() {
        }

        @Test
        public void two() {
        }
    }

    public static class NoExceptionTest {
        @Test(expected=Error.class)
        public void expectedException() {
        }
    }

    public static class ExceptionTest {
        @Test(expected=Error.class)
        public void expectedException() {
            throw new Error();
        }
    }

    public static class OldSuiteTest
    extends TestCase {
        public void testOne() {
            run = true;
        }
    }

    public static class OldTest
    extends TestCase {
        public void test() {
            run = true;
        }
    }

    public static class TwoTests {
        @Test
        public void one() {
            ++count;
            tests.add(this);
        }

        @Test
        public void two() {
            ++count;
            tests.add(this);
        }
    }

    public static class TeardownAfterFailureTest {
        @After
        public void after() {
            run = true;
        }

        @Test
        public void test() throws Exception {
            throw new Exception();
        }
    }

    public static class TestAndTeardownFailureTest {
        @After
        public void after() {
            throw new Error();
        }

        @Test
        public void test() throws Exception {
            throw new Exception();
        }
    }

    public static class TeardownFailureTest {
        @After
        public void after() {
            throw new Error();
        }

        @Test
        public void test() {
        }
    }

    public static class SetupFailureTest {
        @Before
        public void before() {
            throw new Error();
        }

        @Test
        public void test() {
            run = true;
        }
    }

    public static class FailureTest {
        @Test
        public void error() throws Exception {
            Assert.fail();
        }
    }

    public static class TeardownTest {
        @After
        public void after() {
            run = true;
        }

        @Test
        public void success() {
        }
    }

    public static class SetupTest {
        @Before
        public void before() {
            run = true;
        }

        @Test
        public void success() {
        }
    }

    public static class SimpleTest {
        @Test
        public void success() {
            run = true;
        }
    }
}

