/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tests;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;

public class RunWithTest {
    private static String log;

    @Test
    public void run() {
        log = "";
        JUnitCore.runClasses(ExampleTest.class);
        Assert.assertTrue(log.contains("plan"));
        Assert.assertTrue(log.contains("initialize"));
        Assert.assertTrue(log.contains("run"));
    }

    @Test
    public void runWithExtendsToSubclasses() {
        log = "";
        JUnitCore.runClasses(SubExampleTest.class);
        Assert.assertTrue(log.contains("run"));
    }

    @Test
    public void characterizeErrorMessageFromBadRunner() {
        Assert.assertEquals("Custom runner class BadRunner should have a public constructor with signature BadRunner(Class testClass)", JUnitCore.runClasses(Empty.class).getFailures().get(0).getMessage());
    }

    @RunWith(value=BadRunner.class)
    public static class Empty {
    }

    public static class BadRunner
    extends Runner {
        public Description getDescription() {
            return null;
        }

        public void run(RunNotifier notifier) {
        }
    }

    public static class SubExampleTest
    extends ExampleTest {
    }

    @RunWith(value=ExampleRunner.class)
    public static class ExampleTest {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExampleRunner
    extends Runner {
        public ExampleRunner(Class<?> klass) {
            log = log + "initialize";
        }

        @Override
        public void run(RunNotifier notifier) {
            log = log + "run";
        }

        @Override
        public int testCount() {
            log = log + "count";
            return 0;
        }

        @Override
        public Description getDescription() {
            log = log + "plan";
            return Description.createSuiteDescription("example");
        }
    }
}

