/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.CountingInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.CompositeParser;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.SecureContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class AutoDetectParser
extends CompositeParser {
    private Detector detector;

    public AutoDetectParser() {
        try {
            this.setConfig(TikaConfig.getDefaultConfig((Parser)this));
        }
        catch (TikaException e) {
            throw new RuntimeException(e);
        }
    }

    public AutoDetectParser(TikaConfig config) {
        this.setConfig(config);
    }

    public void setConfig(TikaConfig config) {
        this.setParsers(config.getParsers());
        this.setDetector((Detector)config.getMimeRepository());
    }

    public Detector getDetector() {
        return this.detector;
    }

    public void setDetector(Detector detector) {
        this.detector = detector;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        MediaType type = this.detector.detect(stream, metadata);
        metadata.set("Content-Type", type.toString());
        CountingInputStream count = new CountingInputStream(stream);
        SecureContentHandler secure = new SecureContentHandler(handler, count);
        try {
            super.parse((InputStream)count, (ContentHandler)secure, metadata);
        }
        catch (SAXException e) {
            secure.throwIfCauseOf(e);
            throw e;
        }
    }
}

