/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.audio;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class AudioParser
implements Parser {
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        BufferedInputStream buffered = new BufferedInputStream(stream);
        try {
            int bits;
            int channels;
            AudioFormat format = AudioSystem.getAudioFileFormat(buffered).getFormat();
            float rate = format.getSampleRate();
            if (rate != -1.0f) {
                metadata.set("samplerate", String.valueOf(rate));
            }
            if ((channels = format.getChannels()) != -1) {
                metadata.set("channels", String.valueOf(channels));
            }
            if ((bits = format.getSampleSizeInBits()) != -1) {
                metadata.set("bits", String.valueOf(bits));
            }
            metadata.set("encoding", format.getEncoding().toString());
            for (Map.Entry<String, Object> entry : format.properties().entrySet()) {
                metadata.set(entry.getKey(), entry.getValue().toString());
            }
        }
        catch (UnsupportedAudioFileException e) {
            // empty catch block
        }
        xhtml.endDocument();
    }
}

