/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.txt;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.txt.CharsetDetector;
import org.apache.tika.parser.txt.CharsetMatch;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TXTParser
implements Parser {
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        CharsetDetector detector = new CharsetDetector();
        String encoding = metadata.get("Content-Encoding");
        if (encoding != null) {
            detector.setDeclaredEncoding(encoding);
        }
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        detector.setText(stream);
        CharsetMatch match = detector.detect();
        if (match == null) {
            throw new TikaException("Unable to detect character encoding");
        }
        BufferedReader reader = new BufferedReader(match.getReader());
        ((Reader)reader).mark(1);
        int bom = ((Reader)reader).read();
        if (bom != 65279) {
            ((Reader)reader).reset();
        }
        metadata.set("Content-Type", "text/plain");
        metadata.set("Content-Encoding", match.getName());
        String language = match.getLanguage();
        if (language != null) {
            metadata.set("Content-Language", match.getLanguage());
            metadata.set("language", match.getLanguage());
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        xhtml.startElement("p");
        char[] buffer = new char[4096];
        int n = reader.read(buffer);
        while (n != -1) {
            xhtml.characters(buffer, 0, n);
            n = reader.read(buffer);
        }
        xhtml.endElement("p");
        xhtml.endDocument();
    }
}

