/*
 * Decompiled with CFR 0.152.
 */
package org.jempbox.xmp;

import java.util.List;
import org.jempbox.impl.XMLUtil;
import org.jempbox.xmp.ResourceEvent;
import org.jempbox.xmp.ResourceRef;
import org.jempbox.xmp.XMPMetadata;
import org.jempbox.xmp.XMPSchema;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMPSchemaMediaManagement
extends XMPSchema {
    public static final String NAMESPACE = "http://ns.adobe.com/xap/1.0/mm/";

    public XMPSchemaMediaManagement(XMPMetadata parent) {
        super(parent, "xmpMM", NAMESPACE);
    }

    public XMPSchemaMediaManagement(Element element, String prefix) {
        super(element, prefix);
    }

    public ResourceRef getDerivedFrom() {
        ResourceRef retval = null;
        NodeList nodes = this.schema.getElementsByTagName(this.prefix + ":DerivedFrom");
        if (nodes.getLength() > 0) {
            Element derived = (Element)nodes.item(0);
            retval = new ResourceRef(derived);
        } else {
            NodeList deprecatedNodes = this.schema.getElementsByTagName("xmpMM:RenditionOf");
            if (deprecatedNodes.getLength() > 0) {
                Element derived = (Element)deprecatedNodes.item(0);
                retval = new ResourceRef(derived);
            }
        }
        return retval;
    }

    public ResourceRef createDerivedFrom() {
        Element node = this.schema.getOwnerDocument().createElement(this.prefix + ":DerivedFrom");
        ResourceRef ref = new ResourceRef(node);
        return ref;
    }

    public void setDerivedFrom(ResourceRef resource) {
        XMLUtil.setElementableValue(this.schema, this.prefix + ":DerivedFrom", resource);
    }

    public void setDocumentID(String id) {
        this.setTextProperty(this.prefix + ":DocumentID", id);
    }

    public String getDocumentID() {
        return this.getTextProperty(this.prefix + ":DocumentID");
    }

    public void setVersionID(String id) {
        this.setTextProperty(this.prefix + ":VersionID", id);
    }

    public String getVersionID() {
        return this.getTextProperty(this.prefix + ":VersionID");
    }

    public List getHistory() {
        return this.getEventSequenceList(this.prefix + ":History");
    }

    public void removeHistory(ResourceEvent event) {
        this.removeSequenceValue(this.prefix + ":History", event);
    }

    public void addHistory(ResourceEvent event) {
        this.addSequenceValue(this.prefix + ":History", event);
    }

    public ResourceRef getManagedFrom() {
        ResourceRef retval = null;
        NodeList nodes = this.schema.getElementsByTagName(this.prefix + ":ManagedFrom");
        if (nodes.getLength() > 0) {
            Element derived = (Element)nodes.item(0);
            retval = new ResourceRef(derived);
        }
        return retval;
    }

    public ResourceRef createManagedFrom() {
        Element node = this.schema.getOwnerDocument().createElement(this.prefix + ":ManagedFrom");
        ResourceRef ref = new ResourceRef(node);
        return ref;
    }

    public void setManagedFrom(ResourceRef resource) {
        XMLUtil.setElementableValue(this.schema, this.prefix + ":DerivedFrom", resource);
    }

    public void setManager(String manager) {
        this.setTextProperty(this.prefix + ":Manager", manager);
    }

    public String getManager() {
        return this.getTextProperty(this.prefix + ":Manager");
    }

    public void setManageTo(String uri) {
        this.setTextProperty(this.prefix + ":ManageTo", uri);
    }

    public String getManageTo() {
        return this.getTextProperty(this.prefix + ":ManageTo");
    }

    public void setManageUI(String uri) {
        this.setTextProperty(this.prefix + ":ManageUI", uri);
    }

    public String getManageUI() {
        return this.getTextProperty(this.prefix + ":ManageUI");
    }
}

