/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.ContextImpl;
import org.apache.solr.handler.dataimport.DataConfig;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.DocBuilder;
import org.apache.solr.handler.dataimport.Evaluator;
import org.apache.solr.handler.dataimport.JdbcDataSource;
import org.apache.solr.handler.dataimport.MockDataSource;
import org.apache.solr.handler.dataimport.SolrWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataImporter {
    private static final Logger LOG = Logger.getLogger(DataImporter.class.getName());
    private Status status = Status.IDLE;
    private DataConfig config;
    private Date lastIndexTime;
    private Date indexStartTime;
    private Properties store = new Properties();
    private Map<String, Properties> dataSourceProps;
    private IndexSchema schema;
    public DocBuilder docBuilder;
    public DocBuilder.Statistics cumulativeStatistics = new DocBuilder.Statistics();
    public Map<String, Evaluator> evaluators;
    private SolrCore core;
    static final ThreadLocal<AtomicLong> QUERY_COUNT = new ThreadLocal<AtomicLong>(){

        @Override
        protected AtomicLong initialValue() {
            return new AtomicLong();
        }
    };
    static final SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final String COLUMN = "column";
    public static final String TYPE = "type";
    public static final String DATA_SRC = "dataSource";
    public static final String MULTI_VALUED = "multiValued";
    public static final String NAME = "name";
    public static final String STATUS_MSGS = "status-messages";
    public static final String FULL_IMPORT_CMD = "full-import";
    public static final String DELTA_IMPORT_CMD = "delta-import";
    public static final String ABORT_CMD = "abort";
    public static final String DEBUG_MODE = "debug";
    public static final String RELOAD_CONF_CMD = "reload-config";
    public static final String SHOW_CONF_CMD = "show-config";

    DataImporter() {
    }

    DataImporter(String dataConfig, SolrCore core, Map<String, Properties> ds) {
        if (dataConfig == null) {
            throw new DataImportHandlerException(500, "Configuration not found");
        }
        this.core = core;
        this.schema = core.getSchema();
        this.dataSourceProps = ds;
        this.loadDataConfig(dataConfig);
        for (DataConfig.Document document : this.config.documents) {
            for (DataConfig.Entity e : document.entities) {
                HashMap<String, DataConfig.Field> fields = new HashMap<String, DataConfig.Field>();
                this.initEntity(e, fields, false);
                e.implicitFields = new ArrayList<DataConfig.Field>();
                String errs = this.verifyWithSchema(fields, e.implicitFields);
                if (e.implicitFields.isEmpty()) {
                    e.implicitFields = null;
                }
                if (errs == null) continue;
                throw new DataImportHandlerException(500, errs);
            }
        }
    }

    private String verifyWithSchema(Map<String, DataConfig.Field> fields, List<DataConfig.Field> autoFields) {
        ArrayList<String> errors = new ArrayList<String>();
        Map schemaFields = this.schema.getFields();
        for (Map.Entry entry : schemaFields.entrySet()) {
            SchemaField sf = (SchemaField)entry.getValue();
            if (fields.containsKey(sf.getName())) continue;
            if (sf.isRequired()) {
                LOG.info(sf.getName() + " is a required field in SolrSchema . But not found in DataConfig");
            }
            autoFields.add(new DataConfig.Field(sf.getName(), sf.multiValued()));
        }
        for (Map.Entry<Object, Object> entry : fields.entrySet()) {
            DataConfig.Field fld = (DataConfig.Field)entry.getValue();
            FieldType fieldType = null;
            try {
                fieldType = this.schema.getDynamicFieldType(fld.name);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            if (fld.name != null) {
                if (this.schema.getFields().get(fld.name) != null || fieldType != null) continue;
                errors.add("The field :" + fld.name + " present in DataConfig does not have a counterpart in Solr Schema");
                continue;
            }
            if (this.schema.getFields().get(fld.column) != null || fieldType != null) continue;
            LOG.info("Column : " + fld.column + " is not a schema field");
        }
        if (!errors.isEmpty()) {
            StringBuffer sb = new StringBuffer("There are errors in the Schema\n");
            for (String error : errors) {
                sb.append(error).append("\n");
            }
            return sb.toString();
        }
        return null;
    }

    void loadDataConfig(String configFile) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(configFile)));
            this.config = new DataConfig();
            this.config.readFromXml((Element)document.getElementsByTagName("dataConfig").item(0));
            LOG.info("Data Configuration loaded successfully");
        }
        catch (Exception e) {
            SolrConfig.severeErrors.add(e);
            throw new DataImportHandlerException(500, "Exception occurred while initializing context", e);
        }
    }

    private void initEntity(DataConfig.Entity e, Map<String, DataConfig.Field> fields, boolean docRootFound) {
        if (e.pk != null) {
            e.primaryKeys = e.pk.split(",");
        }
        e.allAttributes.put(DATA_SRC, e.dataSource);
        if (!docRootFound && !"false".equals(e.docRoot)) {
            e.isDocRoot = true;
        }
        if (e.fields != null) {
            for (DataConfig.Field f : e.fields) {
                f.nameOrColName = f.getName();
                SchemaField schemaField = (SchemaField)this.schema.getFields().get(f.getName());
                if (schemaField != null) {
                    f.multiValued = schemaField.multiValued();
                    f.allAttributes.put(MULTI_VALUED, Boolean.toString(schemaField.multiValued()));
                    f.allAttributes.put(TYPE, schemaField.getType().getTypeName());
                    f.allAttributes.put("indexed", Boolean.toString(schemaField.indexed()));
                    f.allAttributes.put("stored", Boolean.toString(schemaField.stored()));
                    f.allAttributes.put("defaultValue", schemaField.getDefaultValue());
                } else {
                    try {
                        f.allAttributes.put(TYPE, this.schema.getDynamicFieldType(f.getName()).getTypeName());
                        f.allAttributes.put(MULTI_VALUED, "true");
                        f.multiValued = true;
                    }
                    catch (RuntimeException e2) {
                        LOG.info("Field in data-config.xml - " + f.getName() + " not found in schema.xml");
                        f.toWrite = false;
                    }
                }
                fields.put(f.getName(), f);
                f.entity = e;
                f.allAttributes.put("boost", f.boost.toString());
                f.allAttributes.put("toWrite", Boolean.toString(f.toWrite));
                e.allFieldsList.add(Collections.unmodifiableMap(f.allAttributes));
            }
        }
        e.allFieldsList = Collections.unmodifiableList(e.allFieldsList);
        e.allAttributes = Collections.unmodifiableMap(e.allAttributes);
        this.addDataSource(e);
        if (e.entities == null) {
            return;
        }
        for (DataConfig.Entity e1 : e.entities) {
            e1.parentEntity = e;
            this.initEntity(e1, fields, e.isDocRoot || docRootFound);
        }
    }

    DataConfig getConfig() {
        return this.config;
    }

    Date getIndexStartTime() {
        return this.indexStartTime;
    }

    void setIndexStartTime(Date indextStartTime) {
        this.indexStartTime = indextStartTime;
    }

    Date getLastIndexTime() {
        return this.lastIndexTime;
    }

    void setLastIndexTime(Date lastIndexTime) {
        this.lastIndexTime = lastIndexTime;
    }

    void store(Object key, Object value) {
        this.store.put(key, value);
    }

    Object retrieve(Object key) {
        return this.store.get(key);
    }

    public void addDataSource(DataConfig.Entity key) {
        if ("null".equals(key.dataSource)) {
            key.dataSrc = new MockDataSource();
            return;
        }
        key.dataSrc = this.getDataSourceInstance(key, key.dataSource, null);
    }

    DataSource getDataSourceInstance(DataConfig.Entity key, String name, Context ctx) {
        Properties p = this.dataSourceProps.get(name);
        if (p == null) {
            p = this.config.dataSources.get(name);
        }
        if (p == null) {
            p = this.dataSourceProps.get(null);
        }
        if (p == null) {
            p = this.config.dataSources.get(null);
        }
        if (p == null) {
            throw new DataImportHandlerException(500, "No dataSource :" + name + " available for entity :" + key.name);
        }
        String impl = p.getProperty(TYPE);
        DataSource dataSrc = null;
        if (impl == null) {
            dataSrc = new JdbcDataSource();
        } else {
            try {
                dataSrc = (DataSource)DocBuilder.loadClass(impl, this.getCore()).newInstance();
            }
            catch (Exception e) {
                throw new DataImportHandlerException(500, "Invalid type for data source: " + impl, e);
            }
        }
        try {
            Properties copyProps = new Properties();
            copyProps.putAll((Map<?, ?>)p);
            if (ctx == null) {
                ctx = new ContextImpl(key, null, dataSrc, 0, Collections.EMPTY_MAP, new HashMap<String, Object>(), null, this);
            }
            dataSrc.init(ctx, copyProps);
        }
        catch (Exception e) {
            throw new DataImportHandlerException(500, "Failed to initialize DataSource: " + key.dataSource, e);
        }
        return dataSrc;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFullImport(SolrWriter writer, RequestParams requestParams, Map<String, String> variables) {
        LOG.info("Starting Full Import");
        this.setStatus(Status.RUNNING_FULL_DUMP);
        if (requestParams.commit) {
            this.setIndexStartTime(new Date());
        }
        try {
            if (requestParams.clean) {
                writer.doDeleteAll();
            }
            this.docBuilder = new DocBuilder(this, writer, requestParams, variables);
            this.docBuilder.execute(this.getConfig().documents.get((int)0).name);
            if (!requestParams.debug) {
                this.cumulativeStatistics.add(this.docBuilder.importStatistics);
            }
        }
        catch (RuntimeException e) {
            LOG.log(Level.SEVERE, "Full Import failed", e);
        }
        finally {
            this.setStatus(Status.IDLE);
            this.config.clearCaches();
            DocBuilder.INSTANCE.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDeltaImport(SolrWriter writer, RequestParams requestParams, Map<String, String> variables) {
        LOG.info("Starting Delta Import");
        this.setStatus(Status.RUNNING_DELTA_DUMP);
        try {
            if (requestParams.commit) {
                Date lastModified = writer.loadIndexStartTime();
                this.setIndexStartTime(new Date());
                this.setLastIndexTime(lastModified);
            }
            this.docBuilder = new DocBuilder(this, writer, requestParams, variables);
            this.docBuilder.execute(this.config.documents.get((int)0).name);
            if (!requestParams.debug) {
                this.cumulativeStatistics.add(this.docBuilder.importStatistics);
            }
        }
        catch (RuntimeException e) {
            LOG.log(Level.SEVERE, "Delta Import Failed", e);
        }
        finally {
            this.setStatus(Status.IDLE);
            this.config.clearCaches();
            DocBuilder.INSTANCE.set(null);
        }
    }

    public void runAsync(final RequestParams reqParams, final SolrWriter sw, final Map<String, String> variables) {
        new Thread(){

            public void run() {
                DataImporter.this.runCmd(reqParams, sw, variables);
            }
        }.start();
    }

    void runCmd(RequestParams reqParams, SolrWriter sw, Map<String, String> variables) {
        String command = reqParams.command;
        if (command.equals(FULL_IMPORT_CMD)) {
            this.doFullImport(sw, reqParams, variables);
        } else if (command.equals(DELTA_IMPORT_CMD)) {
            this.doDeltaImport(sw, reqParams, variables);
        } else if (command.equals(ABORT_CMD) && this.docBuilder != null) {
            this.docBuilder.abort();
        }
    }

    Map<String, String> getStatusMessages() {
        Map statusMessages = (Map)this.retrieve(STATUS_MSGS);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (statusMessages != null) {
            Iterator i$ = statusMessages.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry o;
                Map.Entry e = o = i$.next();
                result.put((String)e.getKey(), e.getValue().toString());
            }
        }
        return result;
    }

    DocBuilder getDocBuilder() {
        return this.docBuilder;
    }

    SolrCore getCore() {
        return this.core;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class RequestParams {
        public String command = null;
        public boolean debug = false;
        public boolean verbose = false;
        public boolean commit = true;
        public boolean optimize = true;
        public int start = 0;
        public int rows = 10;
        public boolean clean = true;
        public List<String> entities;
        public Map<String, Object> requestParams;
        public String dataConfig;

        public RequestParams() {
        }

        public RequestParams(Map<String, Object> requestParams) {
            Object o;
            if (requestParams.containsKey("command")) {
                this.command = (String)requestParams.get("command");
            }
            if ("on".equals(requestParams.get(DataImporter.DEBUG_MODE))) {
                this.debug = true;
                this.commit = false;
                this.clean = false;
                boolean bl = this.verbose = "true".equals(requestParams.get("verbose")) || "on".equals(requestParams.get("verbose"));
            }
            if (requestParams.containsKey("commit")) {
                this.commit = Boolean.parseBoolean((String)requestParams.get("commit"));
            }
            if (requestParams.containsKey("start")) {
                this.start = Integer.parseInt((String)requestParams.get("start"));
            }
            if (requestParams.containsKey("rows")) {
                this.rows = Integer.parseInt((String)requestParams.get("rows"));
            }
            if (requestParams.containsKey("clean")) {
                this.clean = Boolean.parseBoolean((String)requestParams.get("clean"));
            }
            if (requestParams.containsKey("optimize")) {
                this.optimize = Boolean.parseBoolean((String)requestParams.get("optimize"));
            }
            if ((o = requestParams.get("entity")) != null && o instanceof String) {
                this.entities = new ArrayList<String>();
                this.entities.add((String)o);
            } else if (o != null && o instanceof List) {
                this.entities = (List)requestParams.get("entity");
            }
            this.dataConfig = (String)requestParams.get("dataConfig");
            if (this.dataConfig != null && this.dataConfig.trim().length() == 0) {
                this.dataConfig = null;
            }
            this.requestParams = requestParams;
        }
    }

    static final class MSG {
        public static final String NO_CONFIG_FOUND = "Configuration not found";
        public static final String NO_INIT = "DataImportHandler started. Not Initialized. No commands can be run";
        public static final String INVALID_CONFIG = "FATAL: Could not create importer. DataImporter config invalid";
        public static final String LOAD_EXP = "Exception while loading DataImporter";
        public static final String JMX_DESC = "Manage data import from databases to Solr";
        public static final String CMD_RUNNING = "A command is still running...";
        public static final String DEBUG_NOT_ENABLED = "Debug not enabled. Add a tag <str name=\"enableDebug\">true</str> in solrconfig.xml";
        public static final String CONFIG_RELOADED = "Configuration Re-loaded sucessfully";
        public static final String TOTAL_DOC_PROCESSED = "Total Documents Processed";
        public static final String TOTAL_QUERIES_EXECUTED = "Total Requests made to DataSource";
        public static final String TOTAL_ROWS_EXECUTED = "Total Rows Fetched";
        public static final String TOTAL_DOCS_DELETED = "Total Documents Deleted";
        public static final String TOTAL_DOCS_SKIPPED = "Total Documents Skipped";

        MSG() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        IDLE,
        RUNNING_FULL_DUMP,
        RUNNING_DELTA_DUMP,
        JOB_FAILED;

    }
}

