/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DebugLogger;
import org.apache.solr.handler.dataimport.DocBuilder;
import org.apache.solr.handler.dataimport.EntityProcessor;
import org.apache.solr.handler.dataimport.ScriptTransformer;
import org.apache.solr.handler.dataimport.Transformer;
import org.apache.solr.handler.dataimport.VariableResolverImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityProcessorBase
extends EntityProcessor {
    private static final Logger LOG = Logger.getLogger(EntityProcessorBase.class.getName());
    protected String entityName;
    protected Context context;
    protected VariableResolverImpl resolver;
    protected Iterator<Map<String, Object>> rowIterator;
    protected List<Transformer> transformers;
    protected List<Map<String, Object>> rowcache;
    protected String query;
    private Map session;
    protected String cachePk;
    protected String cacheVariableName;
    protected Map<String, List<Map<String, Object>>> simpleCache;
    protected Map<String, Map<Object, List<Map<String, Object>>>> cacheWithWhereClause;
    protected List<Map<String, Object>> dataSourceRowCache;
    public static final String TRANSFORMER = "transformer";
    public static final String TRANSFORM_ROW = "transformRow";
    public static final String SKIP_DOC = "$skipDoc";

    @Override
    public void init(Context context) {
        this.rowIterator = null;
        this.rowcache = null;
        this.context = context;
        this.entityName = context.getEntityAttribute("name");
        this.resolver = (VariableResolverImpl)context.getVariableResolver();
        this.query = null;
        this.session = null;
    }

    void loadTransformers() {
        String transClasses = this.context.getEntityAttribute(TRANSFORMER);
        if (transClasses == null) {
            this.transformers = Collections.EMPTY_LIST;
            return;
        }
        String[] transArr = transClasses.split(",");
        this.transformers = new ArrayList<Transformer>(){

            @Override
            public boolean add(Transformer transformer) {
                return super.add(DebugLogger.wrapTransformer(transformer));
            }
        };
        for (String aTransArr : transArr) {
            String trans = aTransArr.trim();
            if (trans.startsWith("script:")) {
                String functionName = trans.substring("script:".length());
                ScriptTransformer scriptTransformer = new ScriptTransformer();
                scriptTransformer.setFunctionName(functionName);
                this.transformers.add(scriptTransformer);
                continue;
            }
            try {
                Class clazz = DocBuilder.loadClass(trans, this.context.getSolrCore());
                if (clazz.newInstance() instanceof Transformer) {
                    this.transformers.add((Transformer)clazz.newInstance());
                    continue;
                }
                Method meth = clazz.getMethod(TRANSFORM_ROW, Map.class);
                if (meth == null) {
                    String msg = "Transformer :" + trans + "does not implement Transformer interface or does not have a transformRow(Map m)method";
                    LOG.log(Level.SEVERE, msg);
                    throw new DataImportHandlerException(500, msg);
                }
                this.transformers.add(new ReflectionTransformer(meth, clazz, trans));
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Unable to load Transformer: " + aTransArr, e);
                throw new DataImportHandlerException(500, (Throwable)e);
            }
        }
    }

    protected Map<String, Object> getFromRowCache() {
        Map<String, Object> r = this.rowcache.remove(0);
        if (this.rowcache.isEmpty()) {
            this.rowcache = null;
        }
        return r;
    }

    protected Map<String, Object> applyTransformer(Map<String, Object> row) {
        if (this.transformers == null) {
            this.loadTransformers();
        }
        if (this.transformers == Collections.EMPTY_LIST) {
            return row;
        }
        Map transformedRow = row;
        List rows = null;
        for (Transformer t : this.transformers) {
            try {
                if (rows != null) {
                    ArrayList<Map> tmpRows = new ArrayList<Map>();
                    for (Map map : rows) {
                        Object o = t.transformRow(map, this.context);
                        if (o == null) continue;
                        if (o instanceof Map) {
                            Map oMap = (Map)o;
                            this.checkSkipDoc(oMap, t);
                            tmpRows.add((Map)o);
                            continue;
                        }
                        if (o instanceof List) {
                            tmpRows.addAll((List)o);
                            continue;
                        }
                        LOG.log(Level.SEVERE, "Transformer must return Map<String, Object> or a List<Map<String, Object>>");
                    }
                    rows = tmpRows;
                    continue;
                }
                Object o = t.transformRow(transformedRow, this.context);
                if (o == null) {
                    return null;
                }
                if (o instanceof Map) {
                    Map oMap = (Map)o;
                    this.checkSkipDoc(oMap, t);
                    transformedRow = (Map)o;
                    continue;
                }
                if (o instanceof List) {
                    rows = (List)o;
                    continue;
                }
                LOG.log(Level.SEVERE, "Transformer must return Map<String, Object> or a List<Map<String, Object>>");
            }
            catch (DataImportHandlerException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "transformer threw error", e);
                throw new DataImportHandlerException(400, (Throwable)e);
            }
        }
        if (rows == null) {
            return transformedRow;
        }
        this.rowcache = rows;
        return this.getFromRowCache();
    }

    private void checkSkipDoc(Map oMap, Transformer t) {
        if (oMap.get(SKIP_DOC) != null && Boolean.parseBoolean(oMap.get(SKIP_DOC).toString())) {
            throw new DataImportHandlerException(300, "Document skipped by: " + DebugLogger.getTransformerName(t));
        }
    }

    protected Map<String, Object> getNext() {
        try {
            if (this.rowIterator == null) {
                return null;
            }
            if (this.rowIterator.hasNext()) {
                return this.rowIterator.next();
            }
            this.rowIterator = null;
            this.query = null;
            return null;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "getNext() failed for query '" + this.query + "'", e);
            this.rowIterator = null;
            this.query = null;
            throw new DataImportHandlerException(400, (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> nextModifiedRowKey() {
        return null;
    }

    @Override
    public Map<String, Object> nextDeletedRowKey() {
        return null;
    }

    @Override
    public Map<String, Object> nextModifiedParentRowKey() {
        return null;
    }

    public void setSessionAttribute(Object key, Object val) {
        if (this.session == null) {
            this.session = new HashMap();
        }
        this.session.put(key, val);
    }

    public Object getSessionAttribute(Object key) {
        if (this.session == null) {
            return null;
        }
        return this.session.get(key);
    }

    @Override
    public Map<String, Object> nextRow() {
        return null;
    }

    @Override
    public void destroy() {
    }

    public void clearSession() {
        if (this.session != null) {
            this.session.clear();
        }
    }

    protected void cacheInit() {
        if (this.simpleCache != null || this.cacheWithWhereClause != null) {
            return;
        }
        String where = this.context.getEntityAttribute("where");
        if (where == null) {
            this.simpleCache = new HashMap<String, List<Map<String, Object>>>();
        } else {
            String[] splits = where.split("=");
            this.cachePk = splits[0];
            this.cacheVariableName = splits[1].trim();
            this.cacheWithWhereClause = new HashMap<String, Map<Object, List<Map<String, Object>>>>();
        }
    }

    protected Map<String, Object> getIdCacheData(String query) {
        Map<Object, List<Map<String, Object>>> rowIdVsRows = this.cacheWithWhereClause.get(query);
        List<Map<String, Object>> rows = null;
        Object key = this.resolver.resolve(this.cacheVariableName);
        if (rowIdVsRows != null) {
            rows = rowIdVsRows.get(key);
            if (rows == null) {
                return null;
            }
            this.dataSourceRowCache = new ArrayList<Map<String, Object>>(rows);
            return this.getFromRowCacheTransformed();
        }
        rows = this.getAllNonCachedRows();
        if (rows.isEmpty()) {
            return null;
        }
        rowIdVsRows = new HashMap<Object, List<Map<String, Object>>>();
        for (Map<String, Object> row : rows) {
            Object k = row.get(this.cachePk);
            if (rowIdVsRows.get(k) == null) {
                rowIdVsRows.put(k, new ArrayList());
            }
            rowIdVsRows.get(k).add(row);
        }
        this.cacheWithWhereClause.put(query, rowIdVsRows);
        if (!rowIdVsRows.containsKey(key)) {
            return null;
        }
        this.dataSourceRowCache = new ArrayList<Map<String, Object>>((Collection)rowIdVsRows.get(key));
        if (this.dataSourceRowCache.isEmpty()) {
            this.dataSourceRowCache = null;
            return null;
        }
        return this.getFromRowCacheTransformed();
    }

    protected List<Map<String, Object>> getAllNonCachedRows() {
        return Collections.EMPTY_LIST;
    }

    protected Map<String, Object> getSimpleCacheData(String query) {
        List<Map<String, Object>> rows = this.simpleCache.get(query);
        if (rows != null) {
            this.dataSourceRowCache = new ArrayList<Map<String, Object>>(rows);
            return this.getFromRowCacheTransformed();
        }
        rows = this.getAllNonCachedRows();
        if (rows.isEmpty()) {
            return null;
        }
        this.dataSourceRowCache = new ArrayList<Map<String, Object>>(rows);
        this.simpleCache.put(query, rows);
        return this.getFromRowCacheTransformed();
    }

    protected Map<String, Object> getFromRowCacheTransformed() {
        Map<String, Object> r = this.dataSourceRowCache.remove(0);
        if (this.dataSourceRowCache.isEmpty()) {
            this.dataSourceRowCache = null;
        }
        return r == null ? null : this.applyTransformer(r);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReflectionTransformer
    extends Transformer {
        final Method meth;
        final Class clazz;
        final String trans;
        final Object o;

        public ReflectionTransformer(Method meth, Class clazz, String trans) throws Exception {
            this.meth = meth;
            this.clazz = clazz;
            this.trans = trans;
            this.o = clazz.newInstance();
        }

        @Override
        public Object transformRow(Map<String, Object> aRow, Context context) {
            try {
                return this.meth.invoke(this.o, aRow);
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "method invocation failed on transformer : " + this.trans, e);
                throw new DataImportHandlerException(400, (Throwable)e);
            }
        }
    }
}

