/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpDataSource
extends DataSource<Reader> {
    Logger LOG = Logger.getLogger(HttpDataSource.class.getName());
    private String baseUrl;
    private String encoding;
    private int connectionTimeout = 5000;
    private int readTimeout = 10000;
    private static final Pattern CHARSET_PATTERN = Pattern.compile(".*?charset=(.*)$", 2);
    public static final String ENCODING = "encoding";
    public static final String BASE_URL = "baseUrl";
    public static final String UTF_8 = "UTF-8";
    public static final String CONNECTION_TIMEOUT_FIELD_NAME = "connectionTimeout";
    public static final String READ_TIMEOUT_FIELD_NAME = "readTimeout";
    public static final int CONNECTION_TIMEOUT = 5000;
    public static final int READ_TIMEOUT = 10000;

    @Override
    public void init(Context context, Properties initProps) {
        this.baseUrl = initProps.getProperty(BASE_URL);
        if (initProps.get(ENCODING) != null) {
            this.encoding = initProps.getProperty(ENCODING);
        }
        String cTimeout = initProps.getProperty(CONNECTION_TIMEOUT_FIELD_NAME);
        String rTimeout = initProps.getProperty(READ_TIMEOUT_FIELD_NAME);
        if (cTimeout != null) {
            try {
                this.connectionTimeout = Integer.parseInt(cTimeout);
            }
            catch (NumberFormatException e) {
                this.LOG.log(Level.WARNING, "Invalid connection timeout: " + cTimeout);
            }
        }
        if (rTimeout != null) {
            try {
                this.readTimeout = Integer.parseInt(rTimeout);
            }
            catch (NumberFormatException e) {
                this.LOG.log(Level.WARNING, "Invalid read timeout: " + rTimeout);
            }
        }
    }

    @Override
    public Reader getData(String query) {
        URL url = null;
        try {
            Matcher m;
            String cType;
            url = query.startsWith("http:") ? new URL(query) : new URL(this.baseUrl + query);
            this.LOG.info("Created URL to: " + url.toString());
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(this.connectionTimeout);
            conn.setReadTimeout(this.readTimeout);
            InputStream in = conn.getInputStream();
            String enc = this.encoding;
            if (enc == null && (cType = conn.getContentType()) != null && (m = CHARSET_PATTERN.matcher(cType)).find()) {
                enc = m.group(1);
            }
            if (enc == null) {
                enc = UTF_8;
            }
            DataImporter.QUERY_COUNT.get().incrementAndGet();
            return new InputStreamReader(in, enc);
        }
        catch (Exception e) {
            this.LOG.log(Level.SEVERE, "Exception thrown while getting data", e);
            throw new DataImportHandlerException(500, "Exception in invoking url " + url, e);
        }
    }

    @Override
    public void close() {
    }
}

