/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.solr.handler.dataimport.TemplateString;
import org.apache.solr.handler.dataimport.VariableResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableResolverImpl
extends VariableResolver {
    private Map<String, Object> container = new HashMap<String, Object>();
    private static final TemplateString TEMPLATE_STRING = new TemplateString();
    static final Pattern DOT_SPLIT = Pattern.compile("\\.");

    public VariableResolverImpl addNamespace(String name, Map<String, Object> map) {
        if (name != null) {
            String[] parts = DOT_SPLIT.split(name, 0);
            Map ns = this.container;
            for (int i = 0; i < parts.length; ++i) {
                if (i == parts.length - 1) {
                    ns.put((String)parts[i], map);
                }
                if (ns.get(parts[i]) == null) {
                    ns.put((String)parts[i], new HashMap());
                    ns = (Map)ns.get(parts[i]);
                    continue;
                }
                if (ns.get(parts[i]) instanceof Map) {
                    ns = (Map)ns.get(parts[i]);
                    continue;
                }
                ns.put(parts[i], new HashMap());
                ns = (Map)ns.get(parts[i]);
            }
        } else {
            this.container.putAll(map);
        }
        return this;
    }

    public void removeNamespace(String name) {
        if (name != null) {
            this.container.remove(name);
        }
    }

    @Override
    public String replaceTokens(String template) {
        return TEMPLATE_STRING.replaceTokens(template, this);
    }

    @Override
    public Object resolve(String name) {
        if (name == null) {
            return this.container;
        }
        if ("".equals(name)) {
            return null;
        }
        String[] parts = DOT_SPLIT.split(name, 0);
        Map namespace = this.container;
        for (int i = 0; i < parts.length; ++i) {
            String thePart = parts[i];
            if (i == parts.length - 1) {
                return namespace.get(thePart);
            }
            Object temp = namespace.get(thePart);
            if (temp == null) {
                return namespace.get(this.mergeAll(parts, i));
            }
            if (!(temp instanceof Map)) {
                return null;
            }
            namespace = (Map)temp;
        }
        return null;
    }

    private String mergeAll(String[] parts, int i) {
        if (i == parts.length - 1) {
            return parts[parts.length - 1];
        }
        StringBuffer sb = new StringBuffer();
        for (int j = i; j < parts.length; ++j) {
            sb.append(parts[j]);
            if (j >= parts.length - 1) continue;
            sb.append(".");
        }
        return sb.toString();
    }
}

