/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public final class TrimFilter
extends TokenFilter {
    final boolean updateOffsets;

    public TrimFilter(TokenStream in, boolean updateOffsets) {
        super(in);
        this.updateOffsets = updateOffsets;
    }

    public final Token next(Token in) throws IOException {
        Token t = this.input.next(in);
        if (null == t || null == t.termBuffer() || t.termLength() == 0) {
            return t;
        }
        char[] termBuffer = t.termBuffer();
        int len = t.termLength();
        int start = 0;
        int end = 0;
        int endOff = 0;
        for (start = 0; start < len && termBuffer[start] <= ' '; ++start) {
        }
        for (end = len; end >= start && termBuffer[end - 1] <= ' '; --end) {
            ++endOff;
        }
        if (start > 0 || end < len) {
            if (start < end) {
                t.setTermBuffer(t.termBuffer(), start, end - start);
            } else {
                t.setTermLength(0);
            }
            if (this.updateOffsets) {
                t.setStartOffset(t.startOffset() + start);
                if (start < end) {
                    t.setEndOffset(t.endOffset() - endOff);
                }
            }
        }
        return t;
    }
}

