/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.logging.Logger;
import javanet.staxutils.BaseXMLInputFactory;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.XML;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryRequestBase;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;

public class XmlUpdateRequestHandler
extends RequestHandlerBase {
    public static Logger log = Logger.getLogger(XmlUpdateRequestHandler.class.getName());
    public static final String UPDATE_PROCESSOR = "update.processor";
    public static final String ADD = "add";
    public static final String DELETE = "delete";
    public static final String OPTIMIZE = "optimize";
    public static final String COMMIT = "commit";
    public static final String WAIT_SEARCHER = "waitSearcher";
    public static final String WAIT_FLUSH = "waitFlush";
    public static final String OVERWRITE = "overwrite";
    public static final String OVERWRITE_COMMITTED = "overwriteCommitted";
    public static final String OVERWRITE_PENDING = "overwritePending";
    public static final String ALLOW_DUPS = "allowDups";
    XMLInputFactory inputFactory;

    public void init(NamedList args) {
        super.init(args);
        this.inputFactory = BaseXMLInputFactory.newInstance();
        try {
            this.inputFactory.setProperty("reuse-instance", Boolean.FALSE);
        }
        catch (IllegalArgumentException ex) {
            log.fine("Unable to set the 'reuse-instance' property for the input chain: " + this.inputFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrParams params = req.getParams();
        UpdateRequestProcessorChain processingChain = req.getCore().getUpdateProcessingChain(params.get(UPDATE_PROCESSOR));
        UpdateRequestProcessor processor = processingChain.createProcessor(req, rsp);
        Iterable<ContentStream> streams = req.getContentStreams();
        if (streams == null) {
            if (!RequestHandlerUtils.handleCommit(processor, params, false)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing content stream");
            }
        } else {
            for (ContentStream stream : req.getContentStreams()) {
                Reader reader = stream.getReader();
                try {
                    XMLStreamReader parser = this.inputFactory.createXMLStreamReader(reader);
                    this.processUpdate(processor, parser);
                }
                finally {
                    IOUtils.closeQuietly((Reader)reader);
                }
            }
            RequestHandlerUtils.handleCommit(processor, params, false);
        }
        processor.finish();
    }

    void processUpdate(UpdateRequestProcessor processor, XMLStreamReader parser) throws XMLStreamException, IOException, FactoryConfigurationError, InstantiationException, IllegalAccessException, TransformerConfigurationException {
        AddUpdateCommand addCmd = null;
        while (true) {
            int event = parser.next();
            switch (event) {
                case 8: {
                    parser.close();
                    return;
                }
                case 1: {
                    String attrVal;
                    String attrName;
                    int i;
                    String currTag = parser.getLocalName();
                    if (currTag.equals(ADD)) {
                        log.finest("SolrCore.update(add)");
                        addCmd = new AddUpdateCommand();
                        boolean overwrite = true;
                        Boolean overwritePending = null;
                        Boolean overwriteCommitted = null;
                        for (i = 0; i < parser.getAttributeCount(); ++i) {
                            attrName = parser.getAttributeLocalName(i);
                            attrVal = parser.getAttributeValue(i);
                            if (OVERWRITE.equals(attrName)) {
                                overwrite = StrUtils.parseBoolean((String)attrVal);
                                continue;
                            }
                            if (ALLOW_DUPS.equals(attrName)) {
                                overwrite = !StrUtils.parseBoolean((String)attrVal);
                                continue;
                            }
                            if (OVERWRITE_PENDING.equals(attrName)) {
                                overwritePending = StrUtils.parseBoolean((String)attrVal);
                                continue;
                            }
                            if (OVERWRITE_COMMITTED.equals(attrName)) {
                                overwriteCommitted = StrUtils.parseBoolean((String)attrVal);
                                continue;
                            }
                            log.warning("Unknown attribute id in add:" + attrName);
                        }
                        if (overwritePending != null && overwriteCommitted != null) {
                            if (overwritePending != overwriteCommitted) {
                                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "can't have different values for 'overwritePending' and 'overwriteCommitted'");
                            }
                            overwrite = overwritePending;
                        }
                        addCmd.overwriteCommitted = overwrite;
                        addCmd.overwritePending = overwrite;
                        addCmd.allowDups = !overwrite;
                        break;
                    }
                    if ("doc".equals(currTag)) {
                        log.finest("adding doc...");
                        addCmd.clear();
                        addCmd.solrDoc = this.readDoc(parser);
                        processor.processAdd(addCmd);
                        break;
                    }
                    if (COMMIT.equals(currTag) || OPTIMIZE.equals(currTag)) {
                        log.finest("parsing " + currTag);
                        CommitUpdateCommand cmd = new CommitUpdateCommand(OPTIMIZE.equals(currTag));
                        boolean sawWaitSearcher = false;
                        boolean sawWaitFlush = false;
                        for (i = 0; i < parser.getAttributeCount(); ++i) {
                            attrName = parser.getAttributeLocalName(i);
                            attrVal = parser.getAttributeValue(i);
                            if (WAIT_FLUSH.equals(attrName)) {
                                cmd.waitFlush = StrUtils.parseBoolean((String)attrVal);
                                sawWaitFlush = true;
                                continue;
                            }
                            if (WAIT_SEARCHER.equals(attrName)) {
                                cmd.waitSearcher = StrUtils.parseBoolean((String)attrVal);
                                sawWaitSearcher = true;
                                continue;
                            }
                            if ("maxSegments".equals(attrName)) {
                                cmd.maxOptimizeSegments = Integer.parseInt(attrVal);
                                continue;
                            }
                            log.warning("unexpected attribute commit/@" + attrName);
                        }
                        if (sawWaitFlush && !sawWaitSearcher) {
                            cmd.waitSearcher = false;
                        }
                        processor.processCommit(cmd);
                        break;
                    }
                    if (!DELETE.equals(currTag)) break;
                    log.finest("parsing delete");
                    this.processDelete(processor, parser);
                }
            }
        }
    }

    void processDelete(UpdateRequestProcessor processor, XMLStreamReader parser) throws XMLStreamException, IOException {
        DeleteUpdateCommand deleteCmd = new DeleteUpdateCommand();
        deleteCmd.fromPending = true;
        deleteCmd.fromCommitted = true;
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String attrName = parser.getAttributeLocalName(i);
            String attrVal = parser.getAttributeValue(i);
            if ("fromPending".equals(attrName)) {
                deleteCmd.fromPending = StrUtils.parseBoolean((String)attrVal);
                continue;
            }
            if ("fromCommitted".equals(attrName)) {
                deleteCmd.fromCommitted = StrUtils.parseBoolean((String)attrVal);
                continue;
            }
            log.warning("unexpected attribute delete/@" + attrName);
        }
        StringBuilder text = new StringBuilder();
        while (true) {
            int event = parser.next();
            switch (event) {
                case 1: {
                    String mode = parser.getLocalName();
                    if (!"id".equals(mode) && !"query".equals(mode)) {
                        log.warning("unexpected XML tag /delete/" + mode);
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unexpected XML tag /delete/" + mode);
                    }
                    text.setLength(0);
                    break;
                }
                case 2: {
                    String currTag = parser.getLocalName();
                    if ("id".equals(currTag)) {
                        deleteCmd.id = text.toString();
                    } else if ("query".equals(currTag)) {
                        deleteCmd.query = text.toString();
                    } else {
                        if (DELETE.equals(currTag)) {
                            return;
                        }
                        log.warning("unexpected XML tag /delete/" + currTag);
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unexpected XML tag /delete/" + currTag);
                    }
                    processor.processDelete(deleteCmd);
                    break;
                }
                case 4: 
                case 6: 
                case 12: {
                    text.append(parser.getText());
                }
            }
        }
    }

    SolrInputDocument readDoc(XMLStreamReader parser) throws XMLStreamException {
        SolrInputDocument doc = new SolrInputDocument();
        String attrName = "";
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            attrName = parser.getAttributeLocalName(i);
            if ("boost".equals(attrName)) {
                doc.setDocumentBoost(Float.parseFloat(parser.getAttributeValue(i)));
                continue;
            }
            log.warning("Unknown attribute doc/@" + attrName);
        }
        StringBuilder text = new StringBuilder();
        String name = null;
        float boost = 1.0f;
        boolean isNull = false;
        block6: while (true) {
            int event = parser.next();
            switch (event) {
                case 4: 
                case 6: 
                case 12: {
                    text.append(parser.getText());
                    break;
                }
                case 2: {
                    if ("doc".equals(parser.getLocalName())) {
                        return doc;
                    }
                    if (!"field".equals(parser.getLocalName()) || isNull) continue block6;
                    doc.addField(name, (Object)text.toString(), boost);
                    boost = 1.0f;
                    break;
                }
                case 1: {
                    text.setLength(0);
                    String localName = parser.getLocalName();
                    if (!"field".equals(localName)) {
                        log.warning("unexpected XML tag doc/" + localName);
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unexpected XML tag doc/" + localName);
                    }
                    boost = 1.0f;
                    String attrVal = "";
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        attrName = parser.getAttributeLocalName(i);
                        attrVal = parser.getAttributeValue(i);
                        if ("name".equals(attrName)) {
                            name = attrVal;
                            continue;
                        }
                        if ("boost".equals(attrName)) {
                            boost = Float.parseFloat(attrVal);
                            continue;
                        }
                        if ("null".equals(attrName)) {
                            isNull = StrUtils.parseBoolean((String)attrVal);
                            continue;
                        }
                        log.warning("Unknown attribute doc/field/@" + attrName);
                    }
                    continue block6;
                }
            }
        }
    }

    @Deprecated
    public void doLegacyUpdate(Reader input, Writer output) {
        try {
            SolrCore core = SolrCore.getSolrCore();
            UpdateRequestProcessorChain processorFactory = core.getUpdateProcessingChain(null);
            MapSolrParams params = new MapSolrParams(new HashMap());
            SolrQueryRequestBase req = new SolrQueryRequestBase(core, (SolrParams)params){};
            SolrQueryResponse rsp = new SolrQueryResponse();
            XMLStreamReader parser = this.inputFactory.createXMLStreamReader(input);
            UpdateRequestProcessor processor = processorFactory.createProcessor(req, rsp);
            this.processUpdate(processor, parser);
            processor.finish();
            output.write("<result status=\"0\"></result>");
        }
        catch (Exception ex) {
            try {
                SolrException.logOnce((Logger)log, (String)"Error processing \"legacy\" update command", (Throwable)ex);
                XML.writeXML((Writer)output, (String)"result", (String)SolrException.toStr((Throwable)ex), (Object[])new Object[]{"status", "1"});
            }
            catch (Exception ee) {
                log.severe("Error writing to output stream: " + ee);
            }
        }
    }

    public String getDescription() {
        return "Add documents with XML";
    }

    public String getVersion() {
        return "$Revision: 690026 $";
    }

    public String getSourceId() {
        return "$Id: XmlUpdateRequestHandler.java 690026 2008-08-28 22:20:00Z yonik $";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/solr/branches/branch-1.3/src/java/org/apache/solr/handler/XmlUpdateRequestHandler.java $";
    }
}

