/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPathConstants;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.params.SpellingParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrEventListener;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.spelling.IndexBasedSpellChecker;
import org.apache.solr.spelling.QueryConverter;
import org.apache.solr.spelling.SolrSpellChecker;
import org.apache.solr.spelling.SpellingQueryConverter;
import org.apache.solr.spelling.SpellingResult;
import org.apache.solr.util.plugin.NamedListPluginLoader;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellCheckComponent
extends SearchComponent
implements SolrCoreAware,
SpellingParams {
    private static final Logger LOG = Logger.getLogger(SpellCheckComponent.class.getName());
    public static final boolean DEFAULT_ONLY_MORE_POPULAR = false;
    public static final String COMPONENT_NAME = "spellcheck";
    protected NamedList initParams;
    protected Map<String, SolrSpellChecker> spellCheckers = new ConcurrentHashMap<String, SolrSpellChecker>();
    protected QueryConverter queryConverter;

    @Override
    public void init(NamedList args) {
        super.init(args);
        this.initParams = args;
    }

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false)) {
            return;
        }
        SolrSpellChecker spellChecker = this.getSpellChecker(params);
        if (params.getBool("spellcheck.build", false)) {
            spellChecker.build(rb.req.getCore(), rb.req.getSearcher());
            rb.rsp.add("command", "build");
        } else if (params.getBool("spellcheck.reload", false)) {
            spellChecker.reload();
            rb.rsp.add("command", "reload");
        }
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false) || this.spellCheckers.isEmpty()) {
            return;
        }
        String q = params.get("spellcheck.q");
        SolrSpellChecker spellChecker = this.getSpellChecker(params);
        Collection<Token> tokens = null;
        if (q != null) {
            tokens = this.getTokens(q, spellChecker.getQueryAnalyzer());
        } else {
            q = rb.getQueryString();
            if (q == null) {
                q = params.get("q");
            }
            tokens = this.queryConverter.convert(q);
        }
        if (tokens != null && !tokens.isEmpty()) {
            if (spellChecker != null) {
                int count = params.getInt("spellcheck.count", 1);
                boolean onlyMorePopular = params.getBool("spellcheck.onlyMorePopular", false);
                boolean extendedResults = params.getBool("spellcheck.extendedResults", false);
                SimpleOrderedMap response = new SimpleOrderedMap();
                IndexReader reader = rb.req.getSearcher().getReader();
                boolean collate = params.getBool("spellcheck.collate", false);
                SpellingResult spellingResult = spellChecker.getSuggestions(tokens, reader, count, onlyMorePopular, extendedResults);
                if (spellingResult != null) {
                    response.add("suggestions", (Object)this.toNamedList(spellingResult, q, extendedResults, collate));
                    rb.rsp.add(COMPONENT_NAME, response);
                }
            } else {
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "Specified dictionary does not exist.");
            }
        }
    }

    private Collection<Token> getTokens(String q, Analyzer analyzer) throws IOException {
        ArrayList<Token> result = new ArrayList<Token>();
        Token token = null;
        TokenStream ts = analyzer.tokenStream("", (Reader)new StringReader(q));
        while ((token = ts.next()) != null) {
            result.add(token);
        }
        return result;
    }

    protected SolrSpellChecker getSpellChecker(SolrParams params) {
        String dictName = params.get("spellcheck.dictionary");
        if (dictName == null) {
            dictName = "default";
        }
        return this.spellCheckers.get(dictName);
    }

    public SolrSpellChecker getSpellChecker(String name) {
        return this.spellCheckers.get(name);
    }

    protected NamedList toNamedList(SpellingResult spellingResult, String origQuery, boolean extendedResults, boolean collate) {
        NamedList result = new NamedList();
        Map<Token, LinkedHashMap<String, Integer>> suggestions = spellingResult.getSuggestions();
        boolean hasFreqInfo = spellingResult.hasTokenFrequencyInfo();
        boolean isCorrectlySpelled = true;
        LinkedHashMap best = null;
        if (collate) {
            best = new LinkedHashMap(suggestions.size());
        }
        for (Map.Entry<Token, LinkedHashMap<String, Integer>> entry : suggestions.entrySet()) {
            Token inputToken = entry.getKey();
            Map theSuggestions = entry.getValue();
            if (theSuggestions == null || theSuggestions.size() <= 0) continue;
            SimpleOrderedMap suggestionList = new SimpleOrderedMap();
            suggestionList.add("numFound", (Object)theSuggestions.size());
            suggestionList.add("startOffset", (Object)inputToken.startOffset());
            suggestionList.add("endOffset", (Object)inputToken.endOffset());
            if (extendedResults && hasFreqInfo) {
                suggestionList.add("origFreq", (Object)spellingResult.getTokenFrequency(inputToken));
                for (Map.Entry suggEntry : theSuggestions.entrySet()) {
                    SimpleOrderedMap suggestionItem = new SimpleOrderedMap();
                    suggestionItem.add("frequency", suggEntry.getValue());
                    suggestionItem.add("word", suggEntry.getKey());
                    suggestionList.add("suggestion", (Object)suggestionItem);
                }
            } else {
                suggestionList.add("suggestion", theSuggestions.keySet());
            }
            if (collate) {
                best.put(inputToken, theSuggestions.keySet().iterator().next());
            }
            if (hasFreqInfo) {
                isCorrectlySpelled = isCorrectlySpelled && spellingResult.getTokenFrequency(inputToken) > 0;
            }
            result.add(new String(inputToken.termBuffer(), 0, inputToken.termLength()), (Object)suggestionList);
        }
        if (hasFreqInfo) {
            result.add("correctlySpelled", (Object)isCorrectlySpelled);
        }
        if (collate) {
            StringBuilder collation = new StringBuilder(origQuery);
            int offset = 0;
            for (Map.Entry entry : best.entrySet()) {
                Token tok = (Token)entry.getKey();
                collation.replace(tok.startOffset() + offset, tok.endOffset() + offset, (String)entry.getValue());
                offset += ((String)entry.getValue()).length() - (tok.endOffset() - tok.startOffset());
            }
            String collVal = collation.toString();
            if (!collVal.equals(origQuery)) {
                LOG.fine("Collation:" + collation);
                result.add("collation", (Object)collVal);
            }
        }
        return result;
    }

    @Override
    public void inform(SolrCore core) {
        if (this.initParams != null) {
            LOG.info("Initializing spell checkers");
            boolean hasDefault = false;
            for (int i = 0; i < this.initParams.size(); ++i) {
                SolrResourceLoader loader;
                SolrSpellChecker checker;
                if (!this.initParams.getName(i).equals("spellchecker")) continue;
                NamedList spellchecker = (NamedList)this.initParams.getVal(i);
                String className = (String)spellchecker.get("classname");
                if (className == null) {
                    className = IndexBasedSpellChecker.class.getName();
                }
                if ((checker = (SolrSpellChecker)(loader = core.getResourceLoader()).newInstance(className, new String[0])) != null) {
                    String dictionary = checker.init(spellchecker, core);
                    if (dictionary != null) {
                        boolean isDefault = dictionary.equals("default");
                        if (isDefault && !hasDefault) {
                            hasDefault = true;
                        } else if (isDefault && hasDefault) {
                            throw new RuntimeException("More than one dictionary is missing name.");
                        }
                        this.spellCheckers.put(dictionary, checker);
                    } else if (!hasDefault) {
                        this.spellCheckers.put("default", checker);
                        hasDefault = true;
                    } else {
                        throw new RuntimeException("More than one dictionary is missing name.");
                    }
                    core.registerFirstSearcherListener(new SpellCheckerListener(core, checker, true));
                    if (!Boolean.parseBoolean((String)spellchecker.get("buildOnCommit"))) continue;
                    LOG.info("Registering newSearcher listener for spellchecker: " + checker.getDictionaryName());
                    core.registerNewSearcherListener(new SpellCheckerListener(core, checker, false));
                    continue;
                }
                throw new RuntimeException("Can't load spell checker: " + className);
            }
            String xpath = "queryConverter";
            SolrConfig solrConfig = core.getSolrConfig();
            NodeList nodes = (NodeList)solrConfig.evaluate(xpath, XPathConstants.NODESET);
            HashMap<String, SpellingQueryConverter> queryConverters = new HashMap<String, SpellingQueryConverter>();
            NamedListPluginLoader loader = new NamedListPluginLoader("[solrconfig.xml] " + xpath, queryConverters);
            loader.load(solrConfig.getResourceLoader(), nodes);
            if (queryConverters.size() == 0) {
                LOG.warning("No queryConverter defined, using default converter");
                queryConverters.put("queryConverter", new SpellingQueryConverter());
            }
            if (queryConverters.size() == 1) {
                this.queryConverter = (QueryConverter)queryConverters.values().iterator().next();
                IndexSchema schema = core.getSchema();
                String fieldTypeName = (String)this.initParams.get("queryAnalyzerFieldType");
                FieldType fieldType = schema.getFieldTypes().get(fieldTypeName);
                WhitespaceAnalyzer analyzer = fieldType == null ? new WhitespaceAnalyzer() : fieldType.getQueryAnalyzer();
                this.queryConverter.setAnalyzer((Analyzer)analyzer);
            }
        }
    }

    public Map<String, SolrSpellChecker> getSpellCheckers() {
        return Collections.unmodifiableMap(this.spellCheckers);
    }

    @Override
    public String getDescription() {
        return "A Spell Checker component";
    }

    @Override
    public String getVersion() {
        return "$Revision:$";
    }

    @Override
    public String getSourceId() {
        return "$Id:$";
    }

    @Override
    public String getSource() {
        return "$URL:$";
    }

    private static class SpellCheckerListener
    implements SolrEventListener {
        private final SolrCore core;
        private final SolrSpellChecker checker;
        private final boolean firstSearcher;

        public SpellCheckerListener(SolrCore core, SolrSpellChecker checker, boolean firstSearcher) {
            this.core = core;
            this.checker = checker;
            this.firstSearcher = firstSearcher;
        }

        public void init(NamedList args) {
        }

        public void newSearcher(SolrIndexSearcher newSearcher, SolrIndexSearcher currentSearcher) {
            if (this.firstSearcher) {
                try {
                    LOG.info("Loading spell index for spellchecker: " + this.checker.getDictionaryName());
                    this.checker.reload();
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "Exception in reloading spell check index for spellchecker: " + this.checker.getDictionaryName(), e);
                }
            } else {
                try {
                    LOG.info("Building spell index for spell checker: " + this.checker.getDictionaryName());
                    this.checker.build(this.core, newSearcher);
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Exception in building spell check index for spellchecker: " + this.checker.getDictionaryName(), e);
                }
            }
        }

        public void postCommit() {
        }
    }
}

