/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.solr.search.IdGenerator;

abstract class PrefixGenerator
implements IdGenerator {
    protected final Term prefix;

    PrefixGenerator(Term prefix) {
        this.prefix = prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndexReader reader) throws IOException {
        TermEnum enumerator = reader.terms(this.prefix);
        TermDocs termDocs = reader.termDocs();
        try {
            Term term;
            String prefixText = this.prefix.text();
            String prefixField = this.prefix.field();
            while ((term = enumerator.term()) != null && term.text().startsWith(prefixText) && term.field() == prefixField) {
                termDocs.seek(term);
                while (termDocs.next()) {
                    this.handleDoc(termDocs.doc());
                }
                if (enumerator.next()) continue;
                break;
            }
        }
        finally {
            termDocs.close();
            enumerator.close();
        }
    }
}

