/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tika.sax.OfflineContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlRootExtractor {
    private final SAXParser parser;

    public XmlRootExtractor() throws SAXException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        this.parser = factory.newSAXParser();
    }

    public QName extractRootElement(byte[] data) {
        ExtractorHandler handler = new ExtractorHandler();
        try {
            this.parser.parse((InputStream)new ByteArrayInputStream(data), (DefaultHandler)new OfflineContentHandler(handler));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return handler.rootElement;
    }

    private static class ExtractorHandler
    extends DefaultHandler {
        private QName rootElement = null;

        private ExtractorHandler() {
        }

        public void startElement(String uri, String local, String name, Attributes attributes) throws SAXException {
            this.rootElement = new QName(uri, local);
            throw new SAXException("Aborting: root element received");
        }
    }
}

