/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TaggedInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.EmptyParser;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.TaggedContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeParser
implements Parser {
    private Map<String, Parser> parsers = new HashMap<String, Parser>();
    private Parser fallback = new EmptyParser();

    public Map<String, Parser> getParsers() {
        return this.parsers;
    }

    public void setParsers(Map<String, Parser> parsers) {
        this.parsers = parsers;
    }

    public Parser getFallback() {
        return this.fallback;
    }

    public void setFallback(Parser fallback) {
        this.fallback = fallback;
    }

    protected Parser getParser(Metadata metadata) {
        Parser parser = this.parsers.get(metadata.get("Content-Type"));
        if (parser == null) {
            parser = this.fallback;
        }
        return parser;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        Parser parser = this.getParser(metadata);
        TaggedInputStream taggedStream = new TaggedInputStream(stream);
        TaggedContentHandler taggedHandler = new TaggedContentHandler(handler);
        try {
            parser.parse(taggedStream, taggedHandler, metadata);
        }
        catch (RuntimeException e) {
            throw new TikaException("Unexpected RuntimeException from " + parser, e);
        }
        catch (IOException e) {
            taggedStream.throwIfCauseOf(e);
            throw new TikaException("TIKA-198: Illegal IOException from " + parser, e);
        }
        catch (SAXException e) {
            taggedHandler.throwIfCauseOf(e);
            throw new TikaException("TIKA-237: Illegal SAXException from " + parser, e);
        }
    }
}

