/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.extractor.impl;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.sax.BodyContentHandler;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.RobotSystemException;
import org.seasar.robot.entity.ExtractData;
import org.seasar.robot.extractor.ExtractException;
import org.seasar.robot.extractor.Extractor;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TikaExtractor
implements Extractor {
    @Override
    public ExtractData getText(InputStream in, Map<String, String> params) {
        if (in == null) {
            throw new RobotSystemException("The inputstream is null.");
        }
        String resourceName = params != null ? params.get("resourceName") : null;
        String contentType = params != null ? params.get("Content-Type") : null;
        Metadata metadata = new Metadata();
        if (StringUtil.isNotEmpty((String)resourceName)) {
            metadata.set("resourceName", resourceName);
        }
        if (StringUtil.isNotBlank((String)contentType)) {
            metadata.set("Content-Type", contentType);
        }
        AutoDetectParser parser = new AutoDetectParser();
        StringWriter writer = new StringWriter();
        try {
            parser.parse(in, (ContentHandler)new BodyContentHandler((Writer)writer), metadata);
        }
        catch (Exception e) {
            throw new ExtractException("Could not extract a content.", e);
        }
        ExtractData extractData = new ExtractData(writer.toString().replaceAll("\\s+$", " ").trim());
        Object[] names = metadata.names();
        Arrays.sort(names);
        for (Object name : names) {
            extractData.putValues((String)name, metadata.getValues((String)name));
        }
        return extractData;
    }
}

