/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.transformer.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.IOUtils;
import org.seasar.robot.RobotCrawlAccessException;
import org.seasar.robot.RobotSystemException;
import org.seasar.robot.entity.AccessResultData;
import org.seasar.robot.entity.ResponseData;
import org.seasar.robot.entity.ResultData;
import org.seasar.robot.transformer.impl.HtmlTransformer;
import org.seasar.robot.util.StreamUtil;

public class FileTransformer
extends HtmlTransformer {
    protected String path;
    protected String questionStr = "_QUEST_";
    protected String colonStr = "_CLN_";
    protected String semicolonStr = "_SCLN_";
    protected String ampersandStr = "_AMP_";
    protected int maxDuplicatedPath = 100;
    protected String charsetName = "UTF-8";
    protected File baseDir;

    protected File createFile(String path) {
        String[] paths = path.split("/");
        File targetFile = this.baseDir;
        for (int i = 0; i < paths.length - 1; ++i) {
            File file = new File(targetFile, paths[i]);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    for (int j = 0; j < this.maxDuplicatedPath; ++j) {
                        file = new File(targetFile, paths[i] + "_" + j);
                        if (file.exists()) {
                            if (!file.isDirectory()) continue;
                        } else if (!file.mkdirs()) {
                            throw new RobotSystemException("Could not create " + file.getAbsolutePath());
                        }
                        break;
                    }
                }
            } else if (!file.mkdirs()) {
                throw new RobotSystemException("Could not create " + file.getAbsolutePath());
            }
            targetFile = file;
        }
        File file = new File(targetFile, paths[paths.length - 1]);
        if (file.exists()) {
            for (int i = 0; i < this.maxDuplicatedPath; ++i) {
                file = new File(targetFile, paths[paths.length - 1] + "_" + i);
                if (file.exists()) continue;
                targetFile = file;
                break;
            }
        } else {
            targetFile = file;
        }
        return targetFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeData(ResponseData responseData, ResultData resultData) {
        resultData.setTransformerName(this.getName());
        this.initBaseDir();
        String url = responseData.getUrl();
        String path = this.getFilePath(url);
        FileTransformer fileTransformer = this;
        synchronized (fileTransformer) {
            File file = this.createFile(path);
            InputStream is = responseData.getResponseBody();
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(file);
                StreamUtil.drain(is, os);
            }
            catch (IOException e) {
                throw new RobotSystemException("Could not store " + file.getAbsolutePath(), e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly((OutputStream)os);
            }
        }
        try {
            resultData.setData(path.getBytes(this.charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new RobotCrawlAccessException("Invalid charsetName: " + this.charsetName, e);
        }
        resultData.setEncoding(this.charsetName);
    }

    private void initBaseDir() {
        if (this.baseDir == null) {
            if (this.path == null) {
                this.baseDir = new File(".");
            } else {
                this.baseDir = new File(this.path);
                if (!this.baseDir.isDirectory() && !this.baseDir.mkdirs()) {
                    throw new RobotSystemException("Could not create " + this.baseDir.getAbsolutePath());
                }
            }
        }
    }

    protected String getFilePath(String url) {
        return url.replaceAll("/+", "/").replaceAll("\\./", "").replaceAll("\\.\\./", "").replaceAll("/$", "/index.html").replaceAll("\\?", this.questionStr).replaceFirst(":", this.colonStr).replaceAll(";", this.semicolonStr).replaceAll("&", this.ampersandStr);
    }

    public Object getData(AccessResultData accessResultData) {
        String filePath;
        if (!this.getName().equals(accessResultData.getTransformerName())) {
            throw new RobotSystemException("Transformer is invalid. Use " + accessResultData.getTransformerName() + ". This transformer is " + this.getName() + ".");
        }
        byte[] data = accessResultData.getData();
        if (data == null) {
            return null;
        }
        String encoding = accessResultData.getEncoding();
        try {
            filePath = new String(data, encoding != null ? encoding : "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            try {
                filePath = new String(data, "UTF-8");
            }
            catch (UnsupportedEncodingException e1) {
                throw new RobotSystemException("Unexpected exception.");
            }
        }
        return new File(this.baseDir, filePath);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getQuestionStr() {
        return this.questionStr;
    }

    public void setQuestionStr(String questionStr) {
        this.questionStr = questionStr;
    }

    public String getColonStr() {
        return this.colonStr;
    }

    public void setColonStr(String colonStr) {
        this.colonStr = colonStr;
    }

    public String getSemicolonStr() {
        return this.semicolonStr;
    }

    public void setSemicolonStr(String semicolonStr) {
        this.semicolonStr = semicolonStr;
    }

    public String getAmpersandStr() {
        return this.ampersandStr;
    }

    public void setAmpersandStr(String ampersandStr) {
        this.ampersandStr = ampersandStr;
    }

    public int getMaxDuplicatedPath() {
        return this.maxDuplicatedPath;
    }

    public void setMaxDuplicatedPath(int maxDuplicatedPath) {
        this.maxDuplicatedPath = maxDuplicatedPath;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }
}

