/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv.core.command;

import java.util.List;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.core.SqlExecution;
import org.seasar.dbflute.bhv.core.SqlExecutionCreator;
import org.seasar.dbflute.bhv.core.command.AbstractSelectCBCommand;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ConditionBeanContext;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.FetchNarrowingBeanContext;
import org.seasar.dbflute.s2dao.jdbc.TnResultSetHandler;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectCursorCBCommand<ENTITY extends Entity>
extends AbstractSelectCBCommand<List<ENTITY>> {
    protected Class<ENTITY> _entityType;
    protected EntityRowHandler<ENTITY> _entityRowHandler;

    @Override
    public String getCommandName() {
        return "selectCursor";
    }

    @Override
    public Class<?> getCommandReturnType() {
        return Object.class;
    }

    @Override
    public boolean isSelectCount() {
        return false;
    }

    @Override
    public void beforeGettingSqlExecution() {
        this.assertStatus("beforeGettingSqlExecution");
        ConditionBean cb = this._conditionBean;
        FetchNarrowingBeanContext.setFetchNarrowingBeanOnThread(cb);
        ConditionBeanContext.setConditionBeanOnThread(cb);
        ConditionBeanContext.setEntityRowHandlerOnThread(this._entityRowHandler);
    }

    @Override
    public void afterExecuting() {
        this.assertStatus("afterExecuting");
    }

    @Override
    public String buildSqlExecutionKey() {
        return super.buildSqlExecutionKey() + ":" + this._entityRowHandler.getClass().getName();
    }

    @Override
    public SqlExecutionCreator createSqlExecutionCreator() {
        this.assertStatus("createSqlExecutionCreator");
        return new SqlExecutionCreator(){

            public SqlExecution createSqlExecution() {
                TnBeanMetaData bmd = SelectCursorCBCommand.this.createBeanMetaData();
                TnResultSetHandler handler = SelectCursorCBCommand.this.createBeanCursorMetaDataResultSetHandler(bmd);
                return SelectCursorCBCommand.this.createSelectCBExecution(SelectCursorCBCommand.this._conditionBeanType, handler);
            }
        };
    }

    protected TnBeanMetaData createBeanMetaData() {
        return this._beanMetaDataFactory.createBeanMetaData(this._entityType);
    }

    @Override
    protected void assertStatus(String methodName) {
        super.assertStatus(methodName);
        if (this._entityType == null) {
            throw new IllegalStateException(this.buildAssertMessage("_entityType", methodName));
        }
        if (this._entityRowHandler == null) {
            throw new IllegalStateException(this.buildAssertMessage("_cursorHandler", methodName));
        }
    }

    public void setEntityType(Class<ENTITY> entityType) {
        this._entityType = entityType;
    }

    public void setEntityRowHandler(EntityRowHandler<ENTITY> entityRowHandler) {
        this._entityRowHandler = entityRowHandler;
    }
}

